/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.service;

import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.geoserver.security.ServiceAccessRule;
import org.geoserver.security.ServiceAccessRuleDAO;
import org.geoserver.web.security.service.AbstractServiceAccessRulePage;
import org.geoserver.web.security.service.ServiceAccessRulePage;
import org.geoserver.web.wicket.ParamResourceModel;

public class NewServiceAccessRulePage
extends AbstractServiceAccessRulePage {
    public NewServiceAccessRulePage() {
        super(new ServiceAccessRule());
        this.form.add((IFormValidator)new DuplicateRuleValidator());
    }

    protected void onFormSubmit() {
        try {
            String roles = this.parseRole(this.rolesForComponent.getRolePalette().getModelObjectAsString());
            ServiceAccessRule rule = new ServiceAccessRule((String)this.service.getConvertedInput(), (String)this.method.getConvertedInput(), new String[]{roles});
            ServiceAccessRuleDAO dao = ServiceAccessRuleDAO.get();
            dao.addRule((Comparable)rule);
            dao.storeRules();
            this.setResponsePage(ServiceAccessRulePage.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred while saving user", e);
            this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}));
        }
    }

    private String parseRole(String modelObjectAsString) {
        return modelObjectAsString.substring(1, modelObjectAsString.length() - 1);
    }

    class DuplicateRuleValidator
    extends AbstractFormValidator {
        DuplicateRuleValidator() {
        }

        public void validate(Form form) {
            ServiceAccessRule rule = new ServiceAccessRule((String)NewServiceAccessRulePage.this.service.getConvertedInput(), (String)NewServiceAccessRulePage.this.method.getConvertedInput(), new String[]{NewServiceAccessRulePage.this.rolesForComponent.getRolePalette().getModelObjectAsString()});
            if (ServiceAccessRuleDAO.get().getRules().contains(rule)) {
                form.error((Serializable)((Object)new ParamResourceModel("duplicateRule", (Component)NewServiceAccessRulePage.this.getPage(), new Object[]{rule.getKey()}).getString()));
            }
        }

        public FormComponent[] getDependentFormComponents() {
            return new FormComponent[]{NewServiceAccessRulePage.this.service, NewServiceAccessRulePage.this.method, NewServiceAccessRulePage.this.rolesForComponent};
        }
    }
}

