/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.io.FilenameFilter;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRangeObject;

public class FilePathFilter
implements FilenameFilter {
    String gridSetPrefix = null;
    String mimeExtension = null;
    TileRangeObject tr;

    public FilePathFilter(TileRangeObject trObj) throws StorageException {
        this.tr = trObj;
        if (this.tr.gridSetId == null) {
            throw new StorageException("Specifying the grid set id is currently mandatory.");
        }
        this.gridSetPrefix = this.tr.gridSetId;
        if (this.tr.mimeType != null) {
            this.mimeExtension = this.tr.mimeType.getFileExtension();
        }
    }

    public boolean accept(File dir, String name) {
        boolean ret = name.startsWith(this.gridSetPrefix) ? this.acceptZoomLevelDir(name) : (name.contains(".") ? this.acceptFileName(dir, name) : this.acceptIntermediateDir(name));
        return ret;
    }

    private boolean acceptZoomLevelDir(String name) {
        int tmp;
        if (!name.startsWith(this.gridSetPrefix)) {
            return false;
        }
        return this.tr.zoomStart == -1 && this.tr.zoomStop == -1 || (tmp = this.findZoomLevel(name)) >= this.tr.zoomStart && tmp <= this.tr.zoomStop;
    }

    private boolean acceptIntermediateDir(String name) {
        return true;
    }

    private boolean acceptFileName(File dir, String name) {
        String[] parts = name.split("\\.");
        if (!parts[parts.length - 1].equalsIgnoreCase(this.mimeExtension)) {
            return false;
        }
        if (this.tr.rangeBounds != null) {
            String[] coords = parts[0].split("_");
            int zoomLevel = this.findZoomLevel(dir.getParentFile().getName());
            long x = Integer.parseInt(coords[0]);
            long y = Integer.parseInt(coords[1]);
            long[] box = this.tr.rangeBounds[zoomLevel];
            if (x < box[0] || x > box[2]) {
                return false;
            }
            if (y < box[1] || y > box[3]) {
                return false;
            }
        }
        return true;
    }

    private int findZoomLevel(String dirName) {
        return Integer.parseInt(dirName.substring(this.gridSetPrefix.length() + 1));
    }
}

