/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.tms;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.storage.StorageBroker;

public class TMSConverter
extends Service {
    public static final String SERVICE_TMS = "tms";
    private StorageBroker sb;
    private TileLayerDispatcher tld;

    public TMSConverter(StorageBroker sb, TileLayerDispatcher tld) {
        super(SERVICE_TMS);
        this.sb = sb;
        this.tld = tld;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        TileLayer tileLayer;
        String[] params = request.getPathInfo().split("/");
        int paramsLength = params.length;
        if (params.length < 5) {
            throw new ServiceException("Expected at least 5 parameters, found " + params.length);
        }
        long[] gridLoc = new long[3];
        String[] yExt = params[paramsLength - 1].split("\\.");
        try {
            gridLoc[0] = Integer.parseInt(params[paramsLength - 2]);
            gridLoc[1] = Integer.parseInt(yExt[0]);
            gridLoc[2] = Integer.parseInt(params[paramsLength - 3]);
        }
        catch (NumberFormatException nfe) {
            throw new ServiceException("Unable to parse number " + nfe.getMessage() + " from " + request.getPathInfo());
        }
        String layerId = params[paramsLength - 4];
        try {
            tileLayer = this.tld.getTileLayer(layerId);
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
        String gridSubsetId = tileLayer.getGridSubsets().keySet().iterator().next();
        MimeType mimeType = null;
        try {
            mimeType = MimeType.createFromExtension(yExt[1]);
        }
        catch (MimeException me) {
            throw new ServiceException("Unable to determine requested format based on extension " + yExt[1]);
        }
        ConveyorTile ret = new ConveyorTile(this.sb, layerId, gridSubsetId, gridLoc, mimeType, null, null, request, response);
        return ret;
    }
}

