/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.mgmaps;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;

public class MGMapsConverter
extends Service {
    public static final String SERVICE_MGMAPS = "mgmaps";
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private GridSetBroker gsb;

    public MGMapsConverter(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb) {
        super(SERVICE_MGMAPS);
        this.sb = sb;
        this.tld = tld;
        this.gsb = gsb;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        String layerId = super.getLayersParameter(request);
        String encoding = request.getCharacterEncoding();
        Map params = request.getParameterMap();
        String strFormat = ServletUtils.stringFromMap(params, encoding, "format");
        String strZoom = ServletUtils.stringFromMap(params, encoding, "zoom");
        String strX = ServletUtils.stringFromMap(params, encoding, "x");
        String strY = ServletUtils.stringFromMap(params, encoding, "y");
        String strCached = ServletUtils.stringFromMap(params, encoding, "cached");
        String strMetaTiled = ServletUtils.stringFromMap(params, encoding, "metatiled");
        long[] gridLoc = MGMapsConverter.convert(Integer.parseInt(strZoom), Integer.parseInt(strX), Integer.parseInt(strY));
        MimeType mimeType = null;
        try {
            if (strFormat == null) {
                strFormat = "image/png";
            }
            mimeType = MimeType.createFromFormat(strFormat);
        }
        catch (MimeException me) {
            throw new ServiceException("Unable to determine requested format, " + strFormat);
        }
        ConveyorTile ret = new ConveyorTile(this.sb, layerId, this.gsb.WORLD_EPSG3857.getName(), gridLoc, mimeType, null, null, request, response);
        if (strCached != null && !Boolean.parseBoolean(strCached)) {
            ret.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            if (strMetaTiled != null && !Boolean.parseBoolean(strMetaTiled)) {
                ret.setHint("not_cached,not_metatiled");
            } else {
                ret.setHint("not_cached");
            }
        }
        return ret;
    }

    public void handleRequest(ConveyorTile tile) throws GeoWebCacheException {
        if (tile.getHint() != null) {
            if (!tile.getHint().equals("not_cached,not_metatiled") && !tile.getHint().equals("not_cached")) {
                throw new GeoWebCacheException("Hint " + tile.getHint() + " is not known.");
            }
            TileLayer tl = this.tld.getTileLayer(tile.getLayerId());
            if (tl == null) {
                throw new GeoWebCacheException("Unknown layer " + tile.getLayerId());
            }
            if (!tl.isCacheBypassAllowed().booleanValue()) {
                throw new GeoWebCacheException("Layer " + tile.getLayerId() + " is not configured to allow bypassing the cache.");
            }
            tile.setTileLayer(tl);
            tl.getNoncachedTile(tile);
            Service.writeTileResponse(tile, false);
        }
    }

    public static long[] convert(long zoomLevel, long x, long y) throws ServiceException {
        if (zoomLevel > 17L) {
            throw new ServiceException("Zoomlevel cannot be greater than 17 for Mobile GMaps");
        }
        long newZoom = 17L - zoomLevel;
        long extent = (long)Math.pow(2.0, newZoom);
        if (x < 0L || x > extent - 1L) {
            throw new ServiceException("The X coordinate is not sane: " + x);
        }
        if (y < 0L || y > extent - 1L) {
            throw new ServiceException("The Y coordinate is not sane: " + y);
        }
        long[] gridLoc = new long[]{x, extent - y - 1L, newZoom};
        return gridLoc;
    }
}

