/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class TextMime
extends MimeType {
    public static final TextMime txt = new TextMime("text/plain", "txt", "txt", "text/plain", true);
    public static final TextMime txtHtml = new TextMime("text/html", "txt.html", "html", "text/html", true);

    private TextMime(String mimeType, String fileExtension, String internalName, String format, boolean noop) {
        super(mimeType, fileExtension, internalName, format, false);
    }

    protected static TextMime checkForFormat(String formatStr) throws MimeException {
        if (formatStr.toLowerCase().startsWith("text")) {
            if (formatStr.equalsIgnoreCase("text/plain")) {
                return txt;
            }
            if (formatStr.startsWith("text/html")) {
                return txtHtml;
            }
        }
        return null;
    }

    protected static TextMime checkForExtension(String fileExtension) throws MimeException {
        if (fileExtension.equalsIgnoreCase("txt")) {
            return txt;
        }
        if (fileExtension.equalsIgnoreCase("txt.html")) {
            return txtHtml;
        }
        return null;
    }
}

