/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;

public abstract class MetaTile
implements TileResponseReceiver {
    protected long[] metaGridCov = null;
    protected long[][] tilesGridPositions = null;
    protected int metaX;
    protected int metaY;
    protected GridSubset gridSubset;
    protected long status = -1L;
    protected boolean error = false;
    protected String errorMessage;
    protected long expiresHeader = -1L;
    protected MimeType responseFormat;
    protected FormatModifier formatModifier;

    protected MetaTile(GridSubset gridSubset, MimeType responseFormat, FormatModifier formatModifier, long[] tileGridPosition, int metaX, int metaY) {
        this.gridSubset = gridSubset;
        this.responseFormat = responseFormat;
        this.formatModifier = formatModifier;
        this.metaX = metaX;
        this.metaY = metaY;
        this.metaGridCov = this.calculateMetaTileGridBounds(gridSubset.getCoverage((int)tileGridPosition[2]), tileGridPosition);
        this.tilesGridPositions = this.calculateTilesGridPositions();
    }

    public int getStatus() {
        return (int)this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean getError() {
        return this.error;
    }

    public void setError() {
        this.error = true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getExpiresHeader() {
        return this.expiresHeader;
    }

    public void setExpiresHeader(long seconds) {
        this.expiresHeader = seconds;
    }

    private long[] calculateMetaTileGridBounds(long[] coverage, long[] tileIdx) {
        long[] metaGridCov;
        metaGridCov = new long[]{tileIdx[0] - tileIdx[0] % (long)this.metaX, tileIdx[1] - tileIdx[1] % (long)this.metaY, Math.min(metaGridCov[0] + (long)this.metaX - 1L, coverage[2]), Math.min(metaGridCov[1] + (long)this.metaY - 1L, coverage[3]), tileIdx[2]};
        this.metaX = (int)(metaGridCov[2] - metaGridCov[0] + 1L);
        this.metaY = (int)(metaGridCov[3] - metaGridCov[1] + 1L);
        return metaGridCov;
    }

    private long[][] calculateTilesGridPositions() {
        if (this.metaX < 0 || this.metaY < 0) {
            return null;
        }
        long[][] tilesGridPos = new long[this.metaX * this.metaY][3];
        for (int y = 0; y < this.metaY; ++y) {
            for (int x = 0; x < this.metaX; ++x) {
                int tile = y * this.metaX + x;
                tilesGridPos[tile][0] = this.metaGridCov[0] + (long)x;
                tilesGridPos[tile][1] = this.metaGridCov[1] + (long)y;
                tilesGridPos[tile][2] = this.metaGridCov[4];
            }
        }
        return tilesGridPos;
    }

    public long[] getMetaGridPos() {
        long[] gridPos = new long[]{this.metaGridCov[0], this.metaGridCov[1], this.metaGridCov[4]};
        return gridPos;
    }

    public long[] getMetaTileGridBounds() {
        return this.metaGridCov;
    }

    public long[][] getTilesGridPositions() {
        return this.tilesGridPositions;
    }

    public SRS getSRS() {
        return this.gridSubset.getSRS();
    }

    public MimeType getResponseFormat() {
        return this.responseFormat;
    }

    public MimeType getRequestFormat() {
        if (this.formatModifier == null) {
            return this.responseFormat;
        }
        return this.formatModifier.getRequestFormat();
    }
}

