/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BoundingBox {
    private static Log log = LogFactory.getLog(BoundingBox.class);
    private static String DELIMITER = ",";
    private static double EQUALITYTHRESHOLD = 0.03;
    public static final BoundingBox WORLD4326 = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
    public static final BoundingBox WORLD3857 = new BoundingBox(-2.003750834E7, -2.003750834E7, 2.003750834E7, 2.003750834E7);
    public double[] coords = new double[4];

    public BoundingBox(BoundingBox bbox) {
        this.coords[0] = bbox.coords[0];
        this.coords[1] = bbox.coords[1];
        this.coords[2] = bbox.coords[2];
        this.coords[3] = bbox.coords[3];
    }

    public BoundingBox(String BBOX) {
        this.setFromBBOXString(BBOX, 0);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public BoundingBox(String[] BBOX) {
        this.setFromStringArray(BBOX);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public BoundingBox(double minx, double miny, double maxx, double maxy) {
        this.coords[0] = minx;
        this.coords[1] = miny;
        this.coords[2] = maxx;
        this.coords[3] = maxy;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public double getWidth() {
        return this.coords[2] - this.coords[0];
    }

    public double getHeight() {
        return this.coords[3] - this.coords[1];
    }

    public void setFromStringArray(String[] BBOX) {
        this.setFromStringArray(BBOX, 0);
    }

    public void setFromStringArray(String[] BBOX, int recWatch) {
        if (BBOX.length == 4) {
            this.coords[0] = Double.valueOf(BBOX[0]);
            this.coords[1] = Double.valueOf(BBOX[1]);
            this.coords[2] = Double.valueOf(BBOX[2]);
            this.coords[3] = Double.valueOf(BBOX[3]);
        } else if (recWatch < 4) {
            this.setFromBBOXString(BBOX[0], recWatch);
        } else {
            log.error((Object)("Doesnt understand " + Arrays.toString(BBOX)));
        }
    }

    public void setFromBBOXString(String BBOX, int recWatch) {
        String[] tokens = BBOX.split(DELIMITER);
        this.setFromStringArray(tokens, recWatch + 1);
    }

    public String getReadableString() {
        return "Min X: " + this.coords[0] + " Min Y: " + this.coords[1] + " Max X: " + this.coords[2] + " Max Y: " + this.coords[3];
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(40);
        buff.append(Double.toString(this.coords[0]));
        buff.append(',');
        buff.append(Double.toString(this.coords[1]));
        buff.append(',');
        buff.append(Double.toString(this.coords[2]));
        buff.append(',');
        buff.append(Double.toString(this.coords[3]));
        return buff.toString();
    }

    public String toKML() {
        return "<LatLonAltBox><north>" + Double.toString(this.coords[3]) + "</north>" + "<south>" + Double.toString(this.coords[1]) + "</south>" + "<east>" + Double.toString(this.coords[2]) + "</east>" + "<west>" + Double.toString(this.coords[0]) + "</west>" + "</LatLonAltBox>";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            BoundingBox other = (BoundingBox)obj;
            boolean result = true;
            for (int i = 0; i < 4 && result; ++i) {
                result = Math.abs(this.coords[i]) < EQUALITYTHRESHOLD && Math.abs(other.coords[i]) < EQUALITYTHRESHOLD || (this.coords[i] - other.coords[i]) / (this.coords[i] + other.coords[i]) < EQUALITYTHRESHOLD;
            }
            return result;
        }
        return false;
    }

    public boolean contains(BoundingBox other) {
        return this.coords[0] - EQUALITYTHRESHOLD <= other.coords[0] && this.coords[1] - EQUALITYTHRESHOLD <= other.coords[1] && this.coords[2] + EQUALITYTHRESHOLD >= other.coords[2] && this.coords[3] + EQUALITYTHRESHOLD >= other.coords[3];
    }

    public boolean isSane() {
        return this.coords[0] < this.coords[2] && this.coords[1] < this.coords[3];
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.coords[0]) ^ Float.floatToIntBits((float)this.coords[2]);
    }

    public static BoundingBox intersection(BoundingBox bboxA, BoundingBox bboxB) {
        int i;
        BoundingBox retBbox = new BoundingBox(0.0, 0.0, 0.0, 0.0);
        for (i = 0; i < 2; ++i) {
            retBbox.coords[i] = bboxA.coords[i] > bboxB.coords[i] ? bboxA.coords[i] : bboxB.coords[i];
        }
        for (i = 2; i < 4; ++i) {
            retBbox.coords[i] = bboxA.coords[i] < bboxB.coords[i] ? bboxA.coords[i] : bboxB.coords[i];
        }
        return retBbox;
    }

    public void scale(double factor) {
        double x = this.coords[2] - this.coords[0];
        double xdiff = (x * factor - x) / 2.0;
        double y = this.coords[3] - this.coords[1];
        double ydiff = (y * factor - y) / 2.0;
        this.coords[0] = this.coords[0] - xdiff;
        this.coords[1] = this.coords[1] - ydiff;
        this.coords[2] = this.coords[2] + xdiff;
        this.coords[3] = this.coords[3] + ydiff;
    }
}

