/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.platform.GeoServerResourceLoader;

public class DataDirectoryConverterLocator
implements IConverterLocator {
    GeoServerResourceLoader resourceLoader;

    public DataDirectoryConverterLocator(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public IConverter getConverter(Class type) {
        if (File.class.isAssignableFrom(type)) {
            return new FileLocator();
        }
        if (URL.class.isAssignableFrom(type)) {
            return new URLLocator();
        }
        if (URI.class.isAssignableFrom(type)) {
            return new URILocator();
        }
        return null;
    }

    File toFile(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        try {
            try {
                URL url = new URL(value);
                if ("file".equals(url.getProtocol())) {
                    value = url.getFile();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            File file = new File(value);
            if (file.isAbsolute()) {
                return file;
            }
            return this.resourceLoader.find(value);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    String fromFile(File file) {
        File data = this.resourceLoader.getBaseDirectory();
        ArrayList<String> path = new ArrayList<String>();
        boolean isChild = false;
        while (file != null) {
            if (file.equals(data)) {
                isChild = true;
                break;
            }
            path.add(file.getName());
            file = file.getParentFile();
        }
        if (isChild) {
            StringBuffer b = new StringBuffer("file:");
            for (int i = path.size() - 1; i > -1; --i) {
                b.append((String)path.get(i)).append(File.separatorChar);
            }
            b.setLength(b.length() - 1);
            return b.toString();
        }
        return null;
    }

    class URILocator
    implements IConverter {
        URILocator() {
        }

        public Object convertToObject(String value, Locale locale) {
            File file = DataDirectoryConverterLocator.this.toFile(value);
            if (file != null) {
                return file.toURI();
            }
            return null;
        }

        public String convertToString(Object value, Locale locale) {
            URI uri = (URI)value;
            try {
                return new URLLocator().convertToString(uri.toURL(), locale);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    class URLLocator
    implements IConverter {
        URLLocator() {
        }

        public Object convertToObject(String value, Locale locale) {
            File file = DataDirectoryConverterLocator.this.toFile(value);
            if (file != null) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            return null;
        }

        public String convertToString(Object value, Locale locale) {
            URL url = (URL)value;
            String file = url.getFile();
            if (file != null && !"".equals(file)) {
                return DataDirectoryConverterLocator.this.fromFile(new File(url.getFile()));
            }
            return null;
        }
    }

    class FileLocator
    implements IConverter {
        FileLocator() {
        }

        public Object convertToObject(String value, Locale locale) {
            return DataDirectoryConverterLocator.this.toFile(value);
        }

        public String convertToString(Object value, Locale locale) {
            return DataDirectoryConverterLocator.this.fromFile((File)value);
        }
    }
}

