/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.namespace.NamespaceDetachableModel;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.URIValidator;
import org.geotools.util.logging.Logging;

public class WorkspaceEditPage
extends GeoServerSecuredPage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.data.workspace");
    IModel wsModel;
    IModel nsModel;
    boolean defaultWs;

    public WorkspaceEditPage(PageParameters parameters) {
        String wsName = parameters.getString("name");
        WorkspaceInfo wsi = this.getCatalog().getWorkspaceByName(wsName);
        if (wsi == null) {
            this.error((Serializable)((Object)new ParamResourceModel("WorkspaceEditPage.notFound", (Component)this, wsName).getString()));
            this.setResponsePage(WorkspacePage.class);
            return;
        }
        this.init(wsi);
    }

    public WorkspaceEditPage(WorkspaceInfo ws) {
        this.init(ws);
    }

    private void init(WorkspaceInfo ws) {
        this.defaultWs = ws.getId().equals(this.getCatalog().getDefaultWorkspace().getId());
        this.wsModel = new WorkspaceDetachableModel(ws);
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(ws.getName());
        this.nsModel = new NamespaceDetachableModel(ns);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this.nsModel)){

            protected void onSubmit() {
                try {
                    WorkspaceEditPage.this.saveWorkspace();
                }
                catch (RuntimeException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                }
            }
        };
        this.add((Component)form);
        TextField name = new TextField("name", (IModel)new PropertyModel((Object)this.wsModel, "name"));
        form.add((Component)name);
        TextField uri = new TextField("uri", (IModel)new PropertyModel((Object)this.nsModel, "uRI"), String.class);
        uri.setRequired(true);
        uri.add((IValidator)new URIValidator());
        form.add((Component)uri);
        CheckBox defaultChk = new CheckBox("default", (IModel)new PropertyModel((Object)this, "defaultWs"));
        form.add((Component)defaultChk);
        SubmitLink submit = new SubmitLink("save");
        form.add((Component)submit);
        form.setDefaultButton((IFormSubmittingComponent)submit);
        form.add((Component)new BookmarkablePageLink("cancel", WorkspacePage.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveWorkspace() {
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceInfo = (NamespaceInfo)this.nsModel.getObject();
        WorkspaceInfo workspaceInfo = (WorkspaceInfo)this.wsModel.getObject();
        namespaceInfo.setPrefix(workspaceInfo.getName());
        DataStoreNamespaceUpdatingListener listener = new DataStoreNamespaceUpdatingListener(workspaceInfo, catalog);
        catalog.addListener((CatalogListener)listener);
        try {
            catalog.save(workspaceInfo);
            catalog.save(namespaceInfo);
            if (this.defaultWs) {
                catalog.setDefaultWorkspace(workspaceInfo);
            }
        }
        finally {
            catalog.removeListener((CatalogListener)listener);
        }
        this.setResponsePage(WorkspacePage.class);
    }

    private static final class DataStoreNamespaceUpdatingListener
    implements CatalogListener {
        private final WorkspaceInfo workspaceInfo;
        private final Catalog catalog;

        public DataStoreNamespaceUpdatingListener(WorkspaceInfo workspaceInfo, Catalog catalog) {
            this.workspaceInfo = workspaceInfo;
            this.catalog = catalog;
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) {
            if (event.getSource() instanceof NamespaceInfo) {
                LOGGER.info("Updating namespace parameter for all DataStoreInfo objects in workspace " + this.workspaceInfo.getName());
                NamespaceInfo nsInfo = (NamespaceInfo)event.getSource();
                String namespaceURI = nsInfo.getURI();
                List stores = this.catalog.getDataStoresByWorkspace(this.workspaceInfo);
                if (stores.size() > 0) {
                    for (DataStoreInfo store : stores) {
                        if (!store.getConnectionParameters().containsKey("namespace")) continue;
                        store.getConnectionParameters().put("namespace", namespaceURI);
                        LOGGER.info("Setting namespace for store " + store.getName() + " to be " + namespaceURI);
                        this.catalog.save((StoreInfo)store);
                    }
                    LOGGER.info("namespace parameter for " + stores.size() + " stores in workspace " + this.workspaceInfo.getName() + " successfully updated");
                } else {
                    LOGGER.info("No stores in workspace " + this.workspaceInfo.getName());
                }
            }
        }

        public void handleModifyEvent(CatalogModifyEvent event) {
        }

        public void reloaded() {
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) {
        }

        public void handleAddEvent(CatalogAddEvent event) {
        }
    }
}

