/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.store.CoverageStoreEditPage;
import org.geoserver.web.data.store.DataAccessEditPage;
import org.geoserver.web.data.store.StoreProvider;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.wicket.ConfirmationAjaxLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorePanel
extends GeoServerTablePanel<StoreInfo> {
    private static final long serialVersionUID = 5957961031378924960L;
    private ModalWindow popupWindow = new ModalWindow("popupWindow");

    public StorePanel(String id) {
        this(id, new StoreProvider(), false);
    }

    public StorePanel(String id, StoreProvider provider, boolean selectable) {
        super(id, provider, selectable);
        this.add((Component)this.popupWindow);
    }

    private Catalog getCatalog() {
        return GeoServerApplication.get().getCatalog();
    }

    @Override
    protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<StoreInfo> property) {
        CatalogIconFactory icons = CatalogIconFactory.get();
        if (property == StoreProvider.TYPE) {
            StoreInfo storeInfo = (StoreInfo)itemModel.getObject();
            ResourceReference storeIcon = icons.getStoreIcon(storeInfo);
            Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)this);
            f.add((Component)new Image("storeIcon", storeIcon));
            return f;
        }
        if (property == StoreProvider.WORKSPACE) {
            return this.workspaceLink(id, itemModel);
        }
        if (property == StoreProvider.NAME) {
            return this.storeNameLink(id, itemModel);
        }
        if (property == StoreProvider.ENABLED) {
            StoreInfo storeInfo = (StoreInfo)itemModel.getObject();
            ResourceReference enabledIcon = storeInfo.isEnabled() ? icons.getEnabledIcon() : icons.getDisabledIcon();
            Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)this);
            f.add((Component)new Image("storeIcon", enabledIcon));
            return f;
        }
        throw new IllegalArgumentException("Don't know a property named " + property.getName());
    }

    private Component storeNameLink(String id, IModel itemModel) {
        String wsName = (String)StoreProvider.WORKSPACE.getModel(itemModel).getObject();
        IModel storeNameModel = StoreProvider.NAME.getModel(itemModel);
        String storeName = (String)storeNameModel.getObject();
        StoreInfo store = this.getCatalog().getStoreByName(wsName, storeName, StoreInfo.class);
        if (store instanceof DataStoreInfo) {
            return new SimpleBookmarkableLink(id, DataAccessEditPage.class, storeNameModel, "storeName", storeName, "wsName", wsName);
        }
        return new SimpleBookmarkableLink(id, CoverageStoreEditPage.class, storeNameModel, "storeName", storeName, "wsName", wsName);
    }

    private Component workspaceLink(String id, IModel itemModel) {
        IModel nameModel = StoreProvider.WORKSPACE.getModel(itemModel);
        return new SimpleBookmarkableLink(id, WorkspaceEditPage.class, nameModel, "name", (String)nameModel.getObject());
    }

    protected Component removeLink(String id, final IModel itemModel) {
        StoreInfo info = (StoreInfo)itemModel.getObject();
        ResourceModel resRemove = new ResourceModel("removeStore", "Remove");
        ParamResourceModel confirmRemove = new ParamResourceModel("confirmRemoveStoreX", (Component)this, info.getName());
        ConfirmationAjaxLink linkPanel = new ConfirmationAjaxLink(id, null, (IModel)resRemove, (IModel)confirmRemove){

            public void onClick(AjaxRequestTarget target) {
                StorePanel.this.getCatalog().remove((StoreInfo)itemModel.getObject());
                target.addComponent((Component)StorePanel.this);
            }
        };
        return linkPanel;
    }
}

