/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.layergroup.LayerGroupEntry;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerGroupEntryPanel
extends Panel {
    ModalWindow popupWindow;
    LayerGroupEntryProvider entryProvider;
    GeoServerTablePanel<LayerGroupEntry> layerTable;
    List<LayerGroupEntry> items = new ArrayList<LayerGroupEntry>();

    public LayerGroupEntryPanel(String id, LayerGroupInfo layerGroup) {
        super(id);
        for (int i = 0; i < layerGroup.getLayers().size(); ++i) {
            LayerInfo layer = (LayerInfo)layerGroup.getLayers().get(i);
            StyleInfo style = (StyleInfo)layerGroup.getStyles().get(i);
            this.items.add(new LayerGroupEntry(layer, style));
        }
        this.popupWindow = new ModalWindow("popup");
        this.add((Component)this.popupWindow);
        this.entryProvider = new LayerGroupEntryProvider(this.items);
        this.layerTable = new GeoServerTablePanel<LayerGroupEntry>("layers", (GeoServerDataProvider)this.entryProvider){

            @Override
            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<LayerGroupEntry> property) {
                if (property == LayerGroupEntryProvider.LAYER) {
                    return LayerGroupEntryPanel.this.layerLink(id, itemModel);
                }
                if (property == LayerGroupEntryProvider.DEFAULT_STYLE) {
                    return LayerGroupEntryPanel.this.defaultStyleCheckbox(id, itemModel);
                }
                if (property == LayerGroupEntryProvider.STYLE) {
                    return LayerGroupEntryPanel.this.styleLink(id, itemModel);
                }
                if (property == LayerGroupEntryProvider.REMOVE) {
                    return LayerGroupEntryPanel.this.removeLink(id, itemModel);
                }
                if (property == LayerGroupEntryProvider.POSITION) {
                    return LayerGroupEntryPanel.this.positionPanel(id, itemModel);
                }
                return null;
            }
        }.setFilterable(false);
        this.add((Component)this.layerTable);
        this.layerTable.setOutputMarkupId(true);
        this.add((Component)new AjaxLink("add"){

            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseLayer", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new LayerGroupEditPage.LayerListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId()){

                    protected void handleLayer(LayerInfo layer, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close(target);
                        LayerGroupEntryPanel.this.entryProvider.getItems().add(new LayerGroupEntry(layer, layer.getDefaultStyle()));
                        target.addComponent(LayerGroupEntryPanel.this.layerTable);
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show(target);
            }
        });
    }

    public List<LayerGroupEntry> getEntries() {
        return this.items;
    }

    Component layerLink(String id, IModel itemModel) {
        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        return new Label(id, entry.getLayer().getName());
    }

    Component defaultStyleCheckbox(String id, IModel itemModel) {
        final LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        Fragment f = new Fragment(id, "defaultStyle", (MarkupContainer)this);
        CheckBox ds = new CheckBox("checkbox", (IModel)new Model((Serializable)Boolean.valueOf(entry.isDefaultStyle())));
        ds.add((IBehavior)new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean useDefault = (Boolean)this.getComponent().getModelObject();
                entry.setDefaultStyle(useDefault);
                target.addComponent(LayerGroupEntryPanel.this.layerTable);
            }
        });
        f.add((Component)ds);
        return f;
    }

    Component styleLink(String id, final IModel itemModel) {
        String styleName;
        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        boolean defaultStyle = true;
        if (entry.getStyle() != null) {
            styleName = entry.getStyle().getName();
            defaultStyle = false;
        } else {
            styleName = entry.getLayer().getDefaultStyle() != null ? entry.getLayer().getDefaultStyle().getName() : null;
        }
        SimpleAjaxLink link = new SimpleAjaxLink(id, (IModel)new Model((Serializable)((Object)styleName))){

            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseStyle", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new LayerGroupEditPage.StyleListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId()){

                    protected void handleStyle(StyleInfo style, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close(target);
                        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
                        entry.setStyle(style);
                        target.addComponent(LayerGroupEntryPanel.this.layerTable);
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show(target);
            }
        };
        link.getLink().setEnabled(!defaultStyle);
        return link;
    }

    Component removeLink(String id, IModel itemModel) {
        final LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        ImageAjaxLink link = new ImageAjaxLink(id, new ResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/delete.png")){

            protected void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.items.remove(entry);
                target.addComponent(LayerGroupEntryPanel.this.layerTable);
            }
        };
        link.getImage().add((IBehavior)new AttributeModifier("alt", true, (IModel)new ParamResourceModel("LayerGroupEditPage.th.remove", (Component)link, new Object[0])));
        return link;
    }

    Component positionPanel(String id, IModel itemModel) {
        return new PositionPanel(id, (LayerGroupEntry)itemModel.getObject());
    }

    class PositionPanel
    extends Panel {
        LayerGroupEntry entry;

        public PositionPanel(String id, LayerGroupEntry entry) {
            ImageAjaxLink blankLink;
            super(id);
            this.entry = entry;
            if (LayerGroupEntryPanel.this.items.indexOf(entry) > 0) {
                ImageAjaxLink upLink = new ImageAjaxLink("up", new ResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/arrow_up.png")){

                    protected void onClick(AjaxRequestTarget target) {
                        int index = LayerGroupEntryPanel.this.items.indexOf(PositionPanel.this.entry);
                        LayerGroupEntryPanel.this.items.remove(index);
                        LayerGroupEntryPanel.this.items.add(index - 1, PositionPanel.this.entry);
                        target.addComponent(LayerGroupEntryPanel.this.layerTable);
                    }
                };
                upLink.getImage().add((IBehavior)new AttributeModifier("alt", true, (IModel)new ParamResourceModel("up", (Component)upLink, new Object[0])));
                this.add((Component)upLink);
            } else {
                blankLink = new ImageAjaxLink("up", new ResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/blank.png")){

                    protected void onClick(AjaxRequestTarget target) {
                    }
                };
                blankLink.getImage().add((IBehavior)new AttributeModifier("alt", true, (IModel)new Model((Serializable)((Object)""))));
                this.add((Component)blankLink);
            }
            if (LayerGroupEntryPanel.this.items.indexOf(entry) < LayerGroupEntryPanel.this.items.size() - 1) {
                ImageAjaxLink downLink = new ImageAjaxLink("down", new ResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/arrow_down.png")){

                    protected void onClick(AjaxRequestTarget target) {
                        int index = LayerGroupEntryPanel.this.items.indexOf(PositionPanel.this.entry);
                        LayerGroupEntryPanel.this.items.remove(index);
                        LayerGroupEntryPanel.this.items.add(index + 1, PositionPanel.this.entry);
                        target.addComponent(LayerGroupEntryPanel.this.layerTable);
                    }
                };
                downLink.getImage().add((IBehavior)new AttributeModifier("alt", true, (IModel)new ParamResourceModel("down", (Component)downLink, new Object[0])));
                this.add((Component)downLink);
            } else {
                blankLink = new ImageAjaxLink("down", new ResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/blank.png")){

                    protected void onClick(AjaxRequestTarget target) {
                    }
                };
                blankLink.getImage().add((IBehavior)new AttributeModifier("alt", true, (IModel)new Model((Serializable)((Object)""))));
                this.add((Component)blankLink);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LayerGroupEntryProvider
    extends GeoServerDataProvider<LayerGroupEntry> {
        public static GeoServerDataProvider.Property<LayerGroupEntry> LAYER = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("layer");
        public static GeoServerDataProvider.Property<LayerGroupEntry> DEFAULT_STYLE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("defaultStyle");
        public static GeoServerDataProvider.Property<LayerGroupEntry> STYLE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("style");
        public static GeoServerDataProvider.Property<LayerGroupEntry> REMOVE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("remove");
        public static GeoServerDataProvider.Property<LayerGroupEntry> POSITION = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("position");
        static List PROPERTIES = Arrays.asList(LAYER, DEFAULT_STYLE, STYLE, REMOVE, POSITION);
        List<LayerGroupEntry> items;

        public LayerGroupEntryProvider(List<LayerGroupEntry> items) {
            this.items = items;
        }

        @Override
        protected List<LayerGroupEntry> getItems() {
            return this.items;
        }

        @Override
        protected List<GeoServerDataProvider.Property<LayerGroupEntry>> getProperties() {
            return PROPERTIES;
        }

        public IModel model(Object object) {
            return new Model((Serializable)((LayerGroupEntry)object));
        }
    }
}

