/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.ListChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.admin.ServerAdminPage;

public class GlobalSettingsPage
extends ServerAdminPage {
    private static final long serialVersionUID = 4716657682337915996L;

    public GlobalSettingsPage() {
        final IModel globalInfoModel = this.getGlobalInfoModel();
        final IModel loggingInfoModel = this.getLoggingInfoModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)globalInfoModel));
        this.add((Component)form);
        form.add((Component)new CheckBox("verbose"));
        form.add((Component)new CheckBox("verboseExceptions"));
        form.add((Component)new TextField("numDecimals"));
        form.add((Component)new TextField("charset"));
        form.add((Component)new TextField("proxyBaseUrl"));
        this.logLevelsAppend(form, loggingInfoModel);
        form.add((Component)new CheckBox("stdOutLogging", (IModel)new PropertyModel((Object)loggingInfoModel, "stdOutLogging")));
        form.add((Component)new TextField("loggingLocation", (IModel)new PropertyModel((Object)loggingInfoModel, "location")));
        Button submit = new Button("submit", (IModel)new StringResourceModel("submit", (Component)this, null)){

            public void onSubmit() {
                GeoServer gs = GlobalSettingsPage.this.getGeoServer();
                gs.save((GeoServerInfo)globalInfoModel.getObject());
                gs.save((LoggingInfo)loggingInfoModel.getObject());
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add((Component)submit);
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add((Component)cancel);
    }

    private void logLevelsAppend(Form form, IModel loggingInfoModel) {
        List<String> logProfiles = Arrays.asList("DEFAULT_LOGGING.properties", "VERBOSE_LOGGING.properties", "PRODUCTION_LOGGING.properties", "GEOTOOLS_DEVELOPER_LOGGING.properties", "GEOSERVER_DEVELOPER_LOGGING.properties");
        form.add((Component)new ListChoice("log4jConfigFile", (IModel)new PropertyModel((Object)loggingInfoModel, "level"), logProfiles));
    }
}

