/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.jai;

import com.sun.media.jai.util.SunTileCache;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RecyclingTileFactory;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.JAIInfo;
import org.geotools.image.jai.Registry;

public class JAIInitializer
implements GeoServerInitializer {
    public void initialize(GeoServer geoServer) throws Exception {
        this.initJAI(geoServer.getGlobal().getJAI());
        geoServer.addListener(new ConfigurationListenerAdapter(){

            @Override
            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                JAIInitializer.this.initJAI(global.getJAI());
            }
        });
    }

    void initJAI(JAIInfo jai) {
        JAI jaiDef = JAI.getDefaultInstance();
        jai.setJAI(jaiDef);
        jaiDef.setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)jai.isRecycling());
        RecyclingTileFactory recyclingFactory = new RecyclingTileFactory();
        jaiDef.setRenderingHint(JAI.KEY_TILE_FACTORY, (Object)recyclingFactory);
        jaiDef.setRenderingHint(JAI.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        SunTileCache jaiCache = (SunTileCache)jaiDef.getTileCache();
        jai.setTileCache(jaiCache);
        long jaiMemory = (long)(jai.getMemoryCapacity() * (double)Runtime.getRuntime().maxMemory());
        jaiCache.setMemoryCapacity(jaiMemory);
        jaiCache.setMemoryThreshold((float)jai.getMemoryThreshold());
        jaiDef.getTileScheduler().setParallelism(jai.getTileThreads());
        jaiDef.getTileScheduler().setPrefetchParallelism(jai.getTileThreads());
        jaiDef.getTileScheduler().setPriority(jai.getTilePriority());
        jaiDef.getTileScheduler().setPrefetchPriority(jai.getTilePriority());
        ImageIO.setUseCache(jai.isImageIOCache());
        Registry.setNativeAccelerationAllowed((String)"Mosaic", (boolean)false, (JAI)jaiDef);
    }
}

