/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.ogrJNI;

public class Feature {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected Feature(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Feature obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            ogrJNI.delete_Feature(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtrAndDisown(Feature obj) {
        if (obj != null) {
            obj.swigCMemOwn = false;
        }
        return Feature.getCPtr(obj);
    }

    public Feature(FeatureDefn feature_def) {
        this(ogrJNI.new_Feature(FeatureDefn.getCPtr(feature_def), feature_def), true);
    }

    public FeatureDefn GetDefnRef() {
        long cPtr = ogrJNI.Feature_GetDefnRef(this.swigCPtr, this);
        return cPtr == 0L ? null : new FeatureDefn(cPtr, false);
    }

    public int SetGeometry(Geometry geom) {
        return ogrJNI.Feature_SetGeometry(this.swigCPtr, this, Geometry.getCPtr(geom), geom);
    }

    public int SetGeometryDirectly(Geometry geom) {
        return ogrJNI.Feature_SetGeometryDirectly(this.swigCPtr, this, Geometry.getCPtrAndDisown(geom), geom);
    }

    public Geometry GetGeometryRef() {
        long cPtr = ogrJNI.Feature_GetGeometryRef(this.swigCPtr, this);
        return cPtr == 0L ? null : new Geometry(cPtr, false);
    }

    public Feature Clone() {
        long cPtr = ogrJNI.Feature_Clone(this.swigCPtr, this);
        return cPtr == 0L ? null : new Feature(cPtr, true);
    }

    public boolean Equal(Feature feature) {
        return ogrJNI.Feature_Equal(this.swigCPtr, this, Feature.getCPtr(feature), feature);
    }

    public int GetFieldCount() {
        return ogrJNI.Feature_GetFieldCount(this.swigCPtr, this);
    }

    public FieldDefn GetFieldDefnRef(int id) {
        long cPtr = ogrJNI.Feature_GetFieldDefnRef__SWIG_0(this.swigCPtr, this, id);
        return cPtr == 0L ? null : new FieldDefn(cPtr, false);
    }

    public FieldDefn GetFieldDefnRef(String name) {
        long cPtr = ogrJNI.Feature_GetFieldDefnRef__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new FieldDefn(cPtr, false);
    }

    public String GetFieldAsString(int id) {
        return ogrJNI.Feature_GetFieldAsString__SWIG_0(this.swigCPtr, this, id);
    }

    public String GetFieldAsString(String name) {
        return ogrJNI.Feature_GetFieldAsString__SWIG_1(this.swigCPtr, this, name);
    }

    public int GetFieldAsInteger(int id) {
        return ogrJNI.Feature_GetFieldAsInteger__SWIG_0(this.swigCPtr, this, id);
    }

    public int GetFieldAsInteger(String name) {
        return ogrJNI.Feature_GetFieldAsInteger__SWIG_1(this.swigCPtr, this, name);
    }

    public double GetFieldAsDouble(int id) {
        return ogrJNI.Feature_GetFieldAsDouble__SWIG_0(this.swigCPtr, this, id);
    }

    public double GetFieldAsDouble(String name) {
        return ogrJNI.Feature_GetFieldAsDouble__SWIG_1(this.swigCPtr, this, name);
    }

    public boolean IsFieldSet(int id) {
        return ogrJNI.Feature_IsFieldSet__SWIG_0(this.swigCPtr, this, id);
    }

    public boolean IsFieldSet(String name) {
        return ogrJNI.Feature_IsFieldSet__SWIG_1(this.swigCPtr, this, name);
    }

    public int GetFieldIndex(String name) {
        return ogrJNI.Feature_GetFieldIndex(this.swigCPtr, this, name);
    }

    public int GetFID() {
        return ogrJNI.Feature_GetFID(this.swigCPtr, this);
    }

    public int SetFID(int fid) {
        return ogrJNI.Feature_SetFID(this.swigCPtr, this, fid);
    }

    public void DumpReadable() {
        ogrJNI.Feature_DumpReadable(this.swigCPtr, this);
    }

    public void UnsetField(int id) {
        ogrJNI.Feature_UnsetField__SWIG_0(this.swigCPtr, this, id);
    }

    public void UnsetField(String name) {
        ogrJNI.Feature_UnsetField__SWIG_1(this.swigCPtr, this, name);
    }

    public void SetField(int id, String value) {
        ogrJNI.Feature_SetField__SWIG_0(this.swigCPtr, this, id, value);
    }

    public void SetField(String name, String value) {
        ogrJNI.Feature_SetField__SWIG_1(this.swigCPtr, this, name, value);
    }

    public int SetFrom(Feature other, int forgiving) {
        return ogrJNI.Feature_SetFrom(this.swigCPtr, this, Feature.getCPtr(other), other, forgiving);
    }

    public String GetStyleString() {
        return ogrJNI.Feature_GetStyleString(this.swigCPtr, this);
    }

    public void SetStyleString(String the_string) {
        ogrJNI.Feature_SetStyleString(this.swigCPtr, this, the_string);
    }

    public int GetFieldType(int id) {
        return ogrJNI.Feature_GetFieldType__SWIG_0(this.swigCPtr, this, id);
    }

    public int GetFieldType(String name) {
        return ogrJNI.Feature_GetFieldType__SWIG_1(this.swigCPtr, this, name);
    }
}

