/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;

public class GWCCleanser {
    private static Logger log = Logging.getLogger((String)"org.geoserver.gwc.GWCCleanser");
    private final StorageBroker sb;

    public GWCCleanser(StorageBroker sb) {
        this.sb = sb;
    }

    public void deleteLayer(String layerName) {
        CleanserThread thread = new CleanserThread(layerName);
        thread.start();
    }

    public void expireLayer(WMSLayer layer) {
        this.deleteLayer(layer.getName());
    }

    private class CleanserThread
    extends Thread {
        String layerName;

        CleanserThread(String layerName) {
            this.layerName = layerName;
        }

        public void run() {
            log.info("Deleting GWC cache for " + this.layerName);
            try {
                GWCCleanser.this.sb.delete(this.layerName);
            }
            catch (StorageException e) {
                log.severe("Failed to clear cache for " + this.layerName + ", " + e.getMessage());
            }
            log.info("GWC cache for " + this.layerName + " deleted successfully");
        }
    }
}

