/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.gdalframework.GDALWritableCommonIIOImageMetadata;
import java.awt.Dimension;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOInvalidTreeException;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.GCP;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDALCommonIIOImageMetadata
extends CoreCommonImageMetadata {
    private static final Logger LOGGER = Logger.getLogger(GDALCommonIIOImageMetadata.class.toString());
    protected Map gdalDomainMetadataMap;

    public GDALCommonIIOImageMetadata(String sDatasetName) {
        this(sDatasetName, "it_geosolutions_imageio_core_commonImageMetadata_1.0", "it.geosolutions.imageio.core.CommonImageMetadataFormat");
    }

    public GDALCommonIIOImageMetadata(String sDatasetName, String formatName, String formatClassName) {
        this(GDALUtilities.acquireDataSet(sDatasetName, gdalconst.GA_ReadOnly), sDatasetName, formatName, formatClassName);
    }

    public GDALCommonIIOImageMetadata(Dataset dataset, String name, boolean initializationRequired, String formatName, String formatClassName) {
        super(false, formatName, formatClassName, null, null);
        Hashtable imageStMap;
        this.setDatasetName(name);
        if (dataset == null) {
            return;
        }
        this.setDatasetDescription(dataset.GetDescription());
        Driver driver = dataset.GetDriver();
        if (driver != null) {
            this.setDriverDescription(driver.GetDescription());
            this.setDriverName(driver.getShortName());
        }
        this.gdalDomainMetadataMap = Collections.synchronizedMap(new HashMap());
        Hashtable defMap = dataset.GetMetadata_Dict("");
        if (defMap != null && defMap.size() > 0) {
            this.gdalDomainMetadataMap.put("DEF", defMap);
        }
        if ((imageStMap = dataset.GetMetadata_Dict("IMAGE_STRUCTURE")) != null && imageStMap.size() > 0) {
            this.gdalDomainMetadataMap.put("IMAGE_STRUCTURE", imageStMap);
        }
        if (initializationRequired) {
            this.setMembers(dataset);
        }
        this.setGeoreferencingInfo(dataset);
        GDALUtilities.closeDataSet(dataset);
    }

    public GDALCommonIIOImageMetadata(Dataset dataset, String name, String formatName, String formatClassName) {
        this(dataset, name, true, formatName, formatClassName);
    }

    public GDALCommonIIOImageMetadata(Dataset dataset, String name, boolean initializationRequired) {
        this(dataset, name, initializationRequired, "it_geosolutions_imageio_core_commonImageMetadata_1.0", "it.geosolutions.imageio.core.CommonImageMetadataFormat");
    }

    private void setGeoreferencingInfo(Dataset dataset) {
        double[] geoT = new double[6];
        dataset.GetGeoTransform(geoT);
        this.setGeoTransformation(geoT);
        this.setProjection(dataset.GetProjection());
        this.setGcpProjection(dataset.GetGCPProjection());
        this.setGcpNumber(dataset.GetGCPCount());
    }

    private boolean setMembers(Dataset dataset) {
        this.setWidth(dataset.getRasterXSize());
        this.setHeight(dataset.getRasterYSize());
        int[] xBlockSize = new int[1];
        int[] yBlockSize = new int[1];
        dataset.GetRasterBand(1).GetBlockSize(xBlockSize, yBlockSize);
        int tileHeight = yBlockSize[0];
        int tileWidth = xBlockSize[0];
        this.setTileHeight(tileHeight);
        this.setTileWidth(tileWidth);
        if ((long)tileHeight * (long)tileWidth > Integer.MAX_VALUE) {
            this.performTileSizeTuning(dataset);
        }
        int numBands = dataset.getRasterCount();
        this.setNumBands(numBands);
        if (numBands <= 0) {
            return false;
        }
        int tileSize = tileWidth * tileHeight * numBands * (gdal.GetDataTypeSize((int)dataset.GetRasterBand(1).getDataType()) / 8);
        int[] banks = new int[numBands];
        int[] offsetsR = new int[numBands];
        Double[] noDataValues = new Double[numBands];
        Double[] scales = new Double[numBands];
        Double[] offsets = new Double[numBands];
        Double[] minimums = new Double[numBands];
        Double[] maximums = new Double[numBands];
        int[] numOverviews = new int[numBands];
        int[] colorInterpretations = new int[numBands];
        int buf_type = 0;
        Band pBand = null;
        Double[] tempD = new Double[1];
        int[] bandsOffset = new int[numBands];
        for (int band = 0; band < numBands; ++band) {
            pBand = dataset.GetRasterBand(band + 1);
            buf_type = pBand.getDataType();
            banks[band] = band;
            offsetsR[band] = 0;
            pBand.GetNoDataValue(tempD);
            noDataValues[band] = tempD[0];
            pBand.GetOffset(tempD);
            offsets[band] = tempD[0];
            pBand.GetScale(tempD);
            scales[band] = tempD[0];
            pBand.GetMinimum(tempD);
            minimums[band] = tempD[0];
            pBand.GetMaximum(tempD);
            maximums[band] = tempD[0];
            colorInterpretations[band] = pBand.GetRasterColorInterpretation();
            numOverviews[band] = pBand.GetOverviewCount();
            bandsOffset[band] = band;
        }
        this.setNoDataValues(noDataValues);
        this.setScales(scales);
        this.setOffsets(offsets);
        this.setMinimums(minimums);
        this.setMaximums(maximums);
        this.setNumOverviews(numOverviews);
        this.setColorInterpretations(colorInterpretations);
        int buffer_type = 0;
        if (buf_type == gdalconstConstants.GDT_Byte) {
            buffer_type = 0;
        } else if (buf_type == gdalconstConstants.GDT_UInt16) {
            buffer_type = 1;
        } else if (buf_type == gdalconstConstants.GDT_Int16) {
            buffer_type = 2;
        } else if (buf_type == gdalconstConstants.GDT_Int32 || buf_type == gdalconstConstants.GDT_UInt32) {
            buffer_type = 3;
        } else if (buf_type == gdalconstConstants.GDT_Float32) {
            buffer_type = 4;
        } else if (buf_type == gdalconstConstants.GDT_Float64) {
            buffer_type = 5;
        } else {
            return false;
        }
        if (tileSize < 0) {
            this.setSampleModel(new BandedSampleModel(buffer_type, tileWidth, tileHeight, tileWidth, banks, offsetsR));
        } else {
            this.setSampleModel(new PixelInterleavedSampleModel(buffer_type, tileWidth, tileHeight, numBands, tileWidth * numBands, bandsOffset));
        }
        if (colorInterpretations[0] == gdalconstConstants.GCI_PaletteIndex) {
            IndexColorModel icm = pBand.GetRasterColorTable().getIndexColorModel(gdal.GetDataTypeSize((int)buf_type));
            this.setColorModel(icm);
        } else {
            this.setColorModel(GDALUtilities.buildColorModel(this.getSampleModel()));
        }
        return this.getColorModel() != null && this.getSampleModel() != null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("mergeTree operation is not allowed");
    }

    public void reset() {
        throw new UnsupportedOperationException("reset operation is not allowed");
    }

    public List<? extends it.geosolutions.imageio.core.GCP> getGCPs() {
        return super.getGCPs();
    }

    private void performTileSizeTuning(Dataset dataset) {
        int width = dataset.getRasterXSize();
        int height = dataset.getRasterYSize();
        Dimension imageSize = new Dimension(width, height);
        Dimension tileSize = GDALUtilities.toTileSize(imageSize);
        this.setTileHeight(tileSize.height);
        this.setTileWidth(tileSize.width);
    }

    protected Map getGdalMetadataDomain(String metadataDomain) {
        if (metadataDomain.equalsIgnoreCase("")) {
            if (this.gdalDomainMetadataMap.containsKey("DEF")) {
                return (Map)this.gdalDomainMetadataMap.get("DEF");
            }
        } else if ((metadataDomain.equalsIgnoreCase("IMAGE_STRUCTURE") || metadataDomain.startsWith("xml:")) && this.gdalDomainMetadataMap.containsKey(metadataDomain)) {
            return (Map)this.gdalDomainMetadataMap.get(metadataDomain);
        }
        return null;
    }

    protected List getGdalMetadataDomainsList() {
        Set keys = this.gdalDomainMetadataMap.keySet();
        ArrayList<String> list = null;
        if (keys != null) {
            Iterator keysIt = keys.iterator();
            list = new ArrayList<String>(keys.size());
            while (keysIt.hasNext()) {
                String key = (String)keysIt.next();
                if (key.equals("DEF")) {
                    list.add("");
                    continue;
                }
                list.add(key);
            }
        }
        return list;
    }

    public GDALWritableCommonIIOImageMetadata asWritable() {
        GDALWritableCommonIIOImageMetadata metadata = new GDALWritableCommonIIOImageMetadata(this.getDatasetName());
        metadata.setDatasetDescription(this.getDatasetDescription());
        metadata.setProjection(this.getProjection());
        metadata.setGcpNumber(this.getGcpNumber());
        metadata.setGcpProjection(this.getGcpProjection());
        metadata.setGeoTransformation(this.getGeoTransformation());
        if (this.gdalDomainMetadataMap != null) {
            Map inputMap = this.gdalDomainMetadataMap;
            Map map = Collections.synchronizedMap(new HashMap(inputMap.size()));
            for (String key : inputMap.keySet()) {
                Map valuesMap = (Map)inputMap.get(key);
                Iterator inKeys = valuesMap.keySet().iterator();
                HashMap<String, String> innerMap = new HashMap<String, String>(valuesMap.size());
                while (inKeys.hasNext()) {
                    String ikey = (String)inKeys.next();
                    String value = (String)valuesMap.get(ikey);
                    innerMap.put(ikey, value);
                }
                map.put(key, innerMap);
            }
            metadata.gdalDomainMetadataMap = map;
        }
        metadata.setWidth(this.getWidth());
        metadata.setHeight(this.getHeight());
        metadata.setTileHeight(this.getTileHeight());
        metadata.setTileWidth(this.getTileWidth());
        metadata.setSampleModel(null);
        SampleModel sm = this.getSampleModel();
        if (sm != null) {
            int smWidth = sm.getWidth();
            int smHeight = sm.getHeight();
            metadata.setSampleModel(sm.createCompatibleSampleModel(smWidth, smHeight));
        }
        metadata.setNumBands(this.getNumBands());
        metadata.setColorModel(null);
        ColorModel cm = this.getColorModel();
        if (cm != null) {
            if (cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                int mapSize = icm.getMapSize();
                byte[] r = new byte[mapSize];
                byte[] g = new byte[mapSize];
                byte[] b = new byte[mapSize];
                icm.getBlues(b);
                icm.getReds(r);
                icm.getGreens(g);
                if (icm.hasAlpha()) {
                    byte[] a = new byte[mapSize];
                    icm.getAlphas(a);
                    metadata.setColorModel(new IndexColorModel(icm.getPixelSize(), mapSize, r, g, b, a));
                } else {
                    metadata.setColorModel(new IndexColorModel(icm.getPixelSize(), mapSize, r, g, b));
                }
            } else {
                metadata.setColorModel(GDALUtilities.buildColorModel(metadata.getSampleModel()));
            }
        }
        metadata.setMaximums(this.getMaximums());
        metadata.setMinimums(this.getMinimums());
        metadata.setNoDataValues(this.getNoDataValues());
        metadata.setScales(this.getScales());
        metadata.setOffsets(this.getOffsets());
        metadata.setNumOverviews(this.getNumOverviews());
        metadata.setColorInterpretations(this.getColorInterpretations());
        return metadata;
    }

    private class GDALGCP
    implements it.geosolutions.imageio.core.GCP {
        private final GCP wrapped;

        public GDALGCP(GCP gcp) {
            if (gcp == null) {
                throw new NullPointerException("Provided GCP is null");
            }
            this.wrapped = gcp;
        }

        public double getGCPLine() {
            return this.wrapped.getGCPLine();
        }

        public double getGCPPixel() {
            return this.wrapped.getGCPPixel();
        }

        public double getGCPX() {
            return this.wrapped.getGCPX();
        }

        public double getGCPY() {
            return this.wrapped.getGCPY();
        }

        public double getGCPZ() {
            return this.wrapped.getGCPZ();
        }

        public String getId() {
            return this.wrapped.getId();
        }

        public String getInfo() {
            return this.wrapped.getInfo();
        }
    }
}

