/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.ows.FeatureSetDescription;
import org.geotools.data.ows.WFSCapabilities;
import org.geotools.data.wfs.v1_0_0.NonStrictWFSStrategy;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.Filters;
import org.geotools.filter.visitor.WFSBBoxFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.XMLHandlerHints;
import org.geotools.xml.filter.FilterEncodingPreProcessor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StrictWFSStrategy
extends NonStrictWFSStrategy {
    protected static final Integer COMPLIANCE_LEVEL = XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MEDIUM;

    public StrictWFSStrategy(WFS_1_0_0_DataStore store) {
        super(store);
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> wrapWithFilteringFeatureReader(Filter postFilter, FeatureReader<SimpleFeatureType, SimpleFeature> reader, Filter processedFilter) {
        FilterEncodingPreProcessor visitor = new FilterEncodingPreProcessor(COMPLIANCE_LEVEL);
        Filters.accept(processedFilter, (FilterVisitor)visitor);
        if (visitor.requiresPostProcessing()) {
            return new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(reader, processedFilter);
        }
        return new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(reader, postFilter);
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(Transaction transaction, Query query) throws IOException {
        return new StrictFeatureReader(transaction, query, COMPLIANCE_LEVEL);
    }

    @Override
    protected CoordinateReferenceSystem correctFilterForServer(String typeName, Filter serverFilter) {
        FeatureSetDescription fsd = WFSCapabilities.getFeatureSetDescription(this.store.capabilities, typeName);
        Envelope maxbbox = null;
        CoordinateReferenceSystem dataCRS = null;
        if (fsd.getSRS() != null) {
            try {
                dataCRS = CRS.decode((String)fsd.getSRS());
                MathTransform toDataCRS = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)dataCRS);
                maxbbox = JTS.transform(fsd.getLatLongBoundingBox(), null, toDataCRS, 10);
            }
            catch (FactoryException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.getMessage());
                maxbbox = null;
            }
            catch (MismatchedDimensionException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.getMessage());
                maxbbox = null;
            }
            catch (TransformException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.getMessage());
                maxbbox = null;
            }
        } else {
            maxbbox = fsd.getLatLongBoundingBox();
        }
        if (maxbbox != null) {
            WFSBBoxFilterVisitor clipVisitor = new WFSBBoxFilterVisitor(maxbbox);
            Filters.accept(serverFilter, clipVisitor);
        } else {
            WFS_1_0_0_DataStore.LOGGER.log(Level.FINE, "Unable to clip your query against the latlongboundingbox element");
        }
        return dataCRS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StrictFeatureReader
    implements FeatureReader<SimpleFeatureType, SimpleFeature> {
        private FeatureReader<SimpleFeatureType, SimpleFeature> delegate;
        protected Filter filter;
        private Query query;
        private Transaction transaction;
        private Set foundFids = new HashSet();
        private SimpleFeature next;

        public StrictFeatureReader(Transaction transaction, Query query, Integer level) throws IOException {
            this.init(transaction, query, level);
        }

        protected void init(Transaction transaction, Query query, Integer level) throws IOException {
            FilterEncodingPreProcessor visitor = new FilterEncodingPreProcessor(level);
            Filters.accept(query.getFilter(), (FilterVisitor)visitor);
            this.transaction = transaction;
            if (visitor.requiresPostProcessing() && query.getPropertyNames() != Query.ALL_NAMES) {
                FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
                query.getFilter().accept((org.opengis.filter.FilterVisitor)attributeExtractor, null);
                HashSet<String> properties = new HashSet<String>(attributeExtractor.getAttributeNameSet());
                properties.addAll(Arrays.asList(query.getPropertyNames()));
                this.query = new DefaultQuery(query.getTypeName(), query.getFilter(), query.getMaxFeatures(), properties.toArray(new String[0]), query.getHandle());
            } else {
                this.query = query;
            }
            this.filter = visitor.getFilter();
            DefaultQuery nonFidQuery = new DefaultQuery(query);
            FidFilter fidFilter = visitor.getFidFilter();
            nonFidQuery.setFilter(fidFilter);
            this.delegate = fidFilter.getIDs().size() > 0 ? StrictWFSStrategy.super.createFeatureReader(transaction, nonFidQuery) : this.nextReader();
        }

        @Override
        public void close() throws IOException {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        @Override
        public SimpleFeatureType getFeatureType() {
            return this.delegate.getFeatureType();
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            if (this.delegate == null) {
                return false;
            }
            if (!this.delegate.hasNext()) {
                this.delegate.close();
                this.delegate = null;
                this.delegate = this.nextReader();
                if (this.delegate == null) {
                    return false;
                }
            }
            try {
                while (this.next == null) {
                    if (!this.delegate.hasNext()) {
                        return false;
                    }
                    this.next = this.delegate.next();
                    if (!this.foundFids.contains(this.next.getID())) continue;
                    this.next = null;
                }
            }
            catch (IllegalAttributeException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            return this.next != null;
        }

        private FeatureReader<SimpleFeatureType, SimpleFeature> nextReader() throws IOException {
            if (this.filter == null || this.filter == Filter.EXCLUDE) {
                return null;
            }
            DefaultQuery query2 = new DefaultQuery(this.query);
            query2.setFilter(this.filter);
            FeatureReader nextReader = StrictWFSStrategy.super.createFeatureReader(this.transaction, query2);
            this.filter = null;
            return nextReader;
        }

        @Override
        public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SimpleFeature tmp = this.next;
            this.foundFids.add(tmp.getID());
            this.next = null;
            return tmp;
        }
    }
}

