/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape.shapehandler.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Rectangle;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class MultiPointHandler
extends org.geotools.renderer.shape.shapehandler.simple.MultiPointHandler {
    private static final GeometryFactory factory = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());

    public MultiPointHandler(ShapeType type, Envelope env, Rectangle screenSize, MathTransform mt, boolean hasOpacity) throws TransformException {
        super(type, env, screenSize, mt, hasOpacity);
    }

    protected Object createGeometry(ShapeType type, Envelope geomBBox, double[][] transformed) {
        double[] coords = new double[transformed.length * 2];
        for (int i = 0; i < transformed.length; ++i) {
            coords[i * 2] = transformed[i][0];
            coords[i * 2 + 1] = transformed[i][1];
        }
        return factory.createMultiPoint((CoordinateSequence)new LiteCoordinateSequence(coords));
    }

    private static class MultiPointCoodinateSequence
    implements CoordinateSequence {
        final double[][] coords;
        volatile Coordinate[] array;

        public MultiPointCoodinateSequence(double[][] ds) {
            this.coords = ds;
        }

        public Envelope expandEnvelope(Envelope env) {
            for (int i = 0; i < this.coords.length; ++i) {
                env.expandToInclude(this.coords[i][0], this.coords[i][1]);
            }
            return env;
        }

        public Object clone() {
            try {
                MultiPointCoodinateSequence other = (MultiPointCoodinateSequence)super.clone();
                return other;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public Coordinate getCoordinate(int i) {
            return new Coordinate(this.coords[i][0], this.coords[i][1]);
        }

        public void getCoordinate(int index, Coordinate coord) {
            coord.x = this.coords[index][0];
            coord.y = this.coords[index][1];
        }

        public Coordinate getCoordinateCopy(int i) {
            return new Coordinate(this.coords[i][0], this.coords[i][1]);
        }

        public int getDimension() {
            return 2;
        }

        public double getOrdinate(int index, int ordinateIndex) {
            return this.coords[index][ordinateIndex];
        }

        public double getX(int index) {
            return this.coords[index][0];
        }

        public double getY(int index) {
            return this.coords[index][1];
        }

        public void setOrdinate(int index, int ordinateIndex, double value) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.coords.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Coordinate[] toCoordinateArray() {
            if (this.array == null) {
                MultiPointCoodinateSequence multiPointCoodinateSequence = this;
                synchronized (multiPointCoodinateSequence) {
                    if (this.array == null) {
                        this.array = new Coordinate[this.size()];
                        for (int i = 0; i < this.array.length; ++i) {
                            this.array[i] = new Coordinate(this.coords[i][0], this.coords[i][1]);
                        }
                    }
                }
            }
            return this.array;
        }
    }
}

