/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.string.JavascriptStripper;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.template.TextTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagedTextTemplate
extends TextTemplate {
    private static final Logger log = LoggerFactory.getLogger((Class)PackagedTextTemplate.class);
    private static final long serialVersionUID = 1L;
    private static final MetaDataKey TEXT_TEMPLATE_CACHE_KEY = new MetaDataKey(TextTemplateCache.class){
        private static final long serialVersionUID = 1L;
    };
    private final StringBuffer buffer;

    public PackagedTextTemplate(Class clazz, String fileName) {
        this(clazz, fileName, "text");
    }

    public PackagedTextTemplate(Class clazz, String fileName, String contentType) {
        this(clazz, fileName, contentType, null);
    }

    /*
     * Loose catch block
     */
    public PackagedTextTemplate(Class clazz, String fileName, String contentType, String encoding) {
        block12: {
            IResourceStream stream;
            block11: {
                super(contentType);
                this.buffer = new StringBuffer();
                String path = Packages.absolutePath(clazz, fileName);
                Application app = Application.get();
                TextTemplateCache cache = (TextTemplateCache)app.getMetaData(TEXT_TEMPLATE_CACHE_KEY);
                stream = new ResourceStreamLocator().locate(clazz, path);
                if (stream == null) {
                    stream = Application.get().getResourceSettings().getResourceStreamLocator().locate(clazz, path);
                }
                if (stream == null) {
                    throw new IllegalArgumentException("resource " + fileName + " not found for scope " + clazz + " (path = " + path + ")");
                }
                if (encoding != null) {
                    this.buffer.append(Streams.readString(stream.getInputStream(), encoding));
                    break block11;
                }
                this.buffer.append(Streams.readString(stream.getInputStream()));
            }
            Object var11_9 = null;
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            break block12;
            {
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ResourceStreamNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    public String getString() {
        if (Application.get().getResourceSettings().getStripJavascriptCommentsAndWhitespace()) {
            return JavascriptStripper.stripCommentsAndWhitespace(this.buffer.toString());
        }
        return this.buffer.toString();
    }

    public final TextTemplate interpolate(Map variables) {
        if (variables != null) {
            String result = new MapVariableInterpolator(this.buffer.toString(), variables).toString();
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append(result);
        }
        return this;
    }

    public final long length() {
        return Strings.lengthInBytes(this.getString(), this.getCharset());
    }

    private static final class TextTemplateCache
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map cache = new ConcurrentHashMap();

        private TextTemplateCache() {
        }

        CachedTextTemplate get(CachedTextTemplateKey key) {
            return (CachedTextTemplate)this.cache.get(key);
        }

        void put(CachedTextTemplateKey key, CachedTextTemplate value) {
            this.cache.put(key, value);
        }
    }

    private static final class CachedTextTemplateKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String className;

        CachedTextTemplateKey(Class clazz, String path) {
            this.className = clazz.getName();
        }
    }

    private static final class CachedTextTemplate
    implements Serializable {
        private static final long serialVersionUID = 1L;

        CachedTextTemplate(String text) {
        }
    }
}

