/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converters;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.converters.DateConverter;

public class SqlTimeConverter
extends DateConverter {
    private static final long serialVersionUID = 1L;

    public Object convertToObject(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat format = DateFormat.getTimeInstance(3, locale);
        try {
            Date date = format.parse(value);
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new ConversionException("Cannot parse '" + value + "' using format " + format).setSourceValue(value).setTargetType(this.getTargetType()).setConverter(this).setLocale(locale);
        }
    }

    public String convertToString(Object value, Locale locale) {
        if (value == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Time time = (Time)value;
        DateFormat format = DateFormat.getTimeInstance(3, locale);
        return format.format(time);
    }

    protected Class getTargetType() {
        return Time.class;
    }
}

