/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;

public class FeedbackPanel
extends Panel
implements IFeedback {
    private static final long serialVersionUID = 1L;
    private final MessageListView messageListView;

    public FeedbackPanel(String id) {
        this(id, (IFeedbackMessageFilter)null);
    }

    public FeedbackPanel(String id, IFeedbackMessageFilter filter) {
        super(id);
        WebMarkupContainer messagesContainer = new WebMarkupContainer("feedbackul"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return FeedbackPanel.this.anyMessage();
            }
        };
        this.add(messagesContainer);
        this.messageListView = new MessageListView("messages");
        this.messageListView.setVersioned(false);
        messagesContainer.add(this.messageListView);
        if (filter != null) {
            this.setFilter(filter);
        }
    }

    public final boolean anyErrorMessage() {
        return this.anyMessage(400);
    }

    public final boolean anyMessage() {
        return this.anyMessage(0);
    }

    public final boolean anyMessage(int level) {
        List msgs = this.getCurrentMessages();
        Iterator i = msgs.iterator();
        while (i.hasNext()) {
            FeedbackMessage msg = (FeedbackMessage)i.next();
            if (!msg.isLevel(level)) continue;
            return true;
        }
        return false;
    }

    public final boolean getEscapeMessages() {
        return this.getEscapeModelStrings();
    }

    public final FeedbackMessagesModel getFeedbackMessagesModel() {
        return (FeedbackMessagesModel)this.messageListView.getModel();
    }

    public final IFeedbackMessageFilter getFilter() {
        return this.getFeedbackMessagesModel().getFilter();
    }

    public final Comparator getSortingComparator() {
        return this.getFeedbackMessagesModel().getSortingComparator();
    }

    public boolean isVersioned() {
        return false;
    }

    public final void setEscapeMessages(boolean escapeMessages) {
        this.setEscapeModelStrings(escapeMessages);
    }

    public final void setFilter(IFeedbackMessageFilter filter) {
        this.getFeedbackMessagesModel().setFilter(filter);
    }

    public final void setMaxMessages(int maxMessages) {
        this.messageListView.setViewSize(maxMessages);
    }

    public final void setSortingComparator(Comparator sortingComparator) {
        this.getFeedbackMessagesModel().setSortingComparator(sortingComparator);
    }

    protected String getCSSClass(FeedbackMessage message) {
        return "feedbackPanel" + message.getLevelAsString();
    }

    protected final List getCurrentMessages() {
        List messages = (List)this.messageListView.getModelObject();
        return Collections.unmodifiableList(messages);
    }

    protected FeedbackMessagesModel newFeedbackMessagesModel() {
        return new FeedbackMessagesModel(this);
    }

    protected Component newMessageDisplayComponent(String id, FeedbackMessage message) {
        Serializable serializable = message.getMessage();
        Label label = new Label(id, serializable == null ? "" : serializable.toString());
        label.setEscapeModelStrings(this.getEscapeModelStrings());
        return label;
    }

    private final class MessageListView
    extends ListView {
        private static final long serialVersionUID = 1L;

        public MessageListView(String id) {
            super(id);
            this.setModel(FeedbackPanel.this.newFeedbackMessagesModel());
        }

        protected void populateItem(ListItem listItem) {
            FeedbackMessage message = (FeedbackMessage)listItem.getModelObject();
            message.markRendered();
            Model replacementModel = new Model(this, message){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ FeedbackMessage val$message;
                private final /* synthetic */ MessageListView this$1;
                {
                    this.this$1 = this$1;
                    this.val$message = val$message;
                }

                public Object getObject() {
                    return MessageListView.access$000(this.this$1).getCSSClass(this.val$message);
                }
            };
            Component label = FeedbackPanel.this.newMessageDisplayComponent("message", message);
            AttributeModifier levelModifier = new AttributeModifier("class", replacementModel);
            label.add(levelModifier);
            listItem.add(levelModifier);
            listItem.add(label);
        }

        protected void onDetach() {
            this.removeAll();
            super.onDetach();
        }

        static /* synthetic */ FeedbackPanel access$000(MessageListView x0) {
            return x0.FeedbackPanel.this;
        }
    }
}

