/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataUtilities;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;

public class PropertyAttributeWriter
implements AttributeWriter {
    BufferedWriter writer;
    SimpleFeatureType type;

    public PropertyAttributeWriter(File file, SimpleFeatureType featureType) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(file));
        this.type = featureType;
        this.writer.write("_=");
        this.writer.write(DataUtilities.spec((FeatureType)this.type));
    }

    public int getAttributeCount() {
        return this.type.getAttributeCount();
    }

    public AttributeDescriptor getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.type.getDescriptor(index);
    }

    public boolean hasNext() throws IOException {
        return false;
    }

    public void next() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.newLine();
        this.writer.flush();
    }

    public void echoLine(String line) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        if (line == null) {
            return;
        }
        this.writer.write(line);
    }

    public void writeFeatureID(String fid) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.write(fid);
    }

    public void write(int position, Object attribute) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.write(position == 0 ? "=" : "|");
        if (attribute != null) {
            if (attribute instanceof Geometry) {
                this.writer.write(((Geometry)attribute).toText());
            } else {
                this.writer.write(attribute.toString());
            }
        }
    }

    public void close() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has already been closed");
        }
        this.writer.close();
        this.writer = null;
        this.type = null;
    }
}

