/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import java.util.Vector;
import javax.media.jai.CRIFImpl;
import org.geotools.image.jai.Combine;
import org.geotools.image.jai.CombineTransform;

public class CombineCRIF
extends CRIFImpl {
    public RenderedImage create(ParameterBlock param, RenderingHints hints) {
        Vector<Object> sources = param.getSources();
        double[][] matrix = (double[][])param.getObjectParameter(0);
        CombineTransform transform = (CombineTransform)param.getObjectParameter(1);
        return transform == null && CombineCRIF.isDyadic(sources, matrix) ? new Combine.Dyadic(sources, matrix, hints) : new Combine(sources, matrix, transform, hints);
    }

    private static boolean isDyadic(List sources, double[][] matrix) {
        if (sources.size() != 2) {
            return false;
        }
        RenderedImage src0 = (RenderedImage)sources.get(0);
        RenderedImage src1 = (RenderedImage)sources.get(1);
        int numBands0 = src0.getSampleModel().getNumBands();
        int numBands1 = src1.getSampleModel().getNumBands();
        int numBands = matrix.length;
        if (numBands != numBands0 || numBands != numBands1) {
            return false;
        }
        for (int i = 0; i < numBands; ++i) {
            double[] row = matrix[i];
            int j = numBands0 + numBands1;
            while (--j >= 0) {
                if (j == i || j == i + numBands0 || row[j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }
}

