/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RegistryElementDescriptor;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.coverage.processing.CannotReprojectException;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.factory.Hints;
import org.geotools.image.jai.Registry;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.parameter.ImagingParameters;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.XArray;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationJAI
extends Operation2D {
    private static final long serialVersionUID = -5974520239347639965L;
    protected static final String RENDERED_MODE = "rendered";
    protected final OperationDescriptor operation;

    public OperationJAI(String operation) throws OperationNotFoundException {
        this(OperationJAI.getOperationDescriptor(operation));
    }

    public OperationJAI(OperationDescriptor operation) {
        this(operation, new ImagingParameterDescriptors((RegistryElementDescriptor)operation));
    }

    protected OperationJAI(OperationDescriptor operation, ParameterDescriptorGroup descriptor) {
        super(descriptor);
        this.operation = operation;
        OperationJAI.ensureNonNull("operation", operation);
        OperationJAI.ensureRenderedImage(operation.getDestClass(RENDERED_MODE));
        Class[] sourceClasses = operation.getSourceClasses(RENDERED_MODE);
        if (sourceClasses != null) {
            int length = sourceClasses.length;
            assert (length == operation.getNumSources());
            for (int i = 0; i < length; ++i) {
                OperationJAI.ensureRenderedImage(sourceClasses[i]);
            }
        }
        assert (super.getNumSources() == operation.getNumSources());
    }

    protected static OperationDescriptor getOperationDescriptor(String name) throws OperationNotFoundException {
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        OperationDescriptor operation = (OperationDescriptor)registry.getDescriptor(RENDERED_MODE, name);
        if (operation != null) {
            return operation;
        }
        if (name.startsWith("org.geotools.") && registry.getDescriptor(RENDERED_MODE, "org.geotools.Combine") == null) {
            try {
                Registry.registerGeotoolsServices(registry);
            }
            catch (RuntimeException e) {
                Logging.unexpectedException((Logger)AbstractProcessor.LOGGER, OperationJAI.class, (String)"getOperationDescriptor", (Throwable)e);
            }
            operation = (OperationDescriptor)registry.getDescriptor(RENDERED_MODE, name);
            if (operation != null) {
                return operation;
            }
        }
        throw new OperationNotFoundException(Errors.format((int)152, (Object)name));
    }

    private static final void ensureRenderedImage(Class<?> classe) throws IllegalArgumentException {
        if (!RenderedImage.class.isAssignableFrom(classe)) {
            throw new IllegalArgumentException(classe.getName());
        }
    }

    protected ParameterBlockJAI prepareParameters(ParameterValueGroup parameters) {
        ImagingParameters copy = (ImagingParameters)this.descriptor.createValue();
        ParameterBlockJAI block = (ParameterBlockJAI)copy.parameters;
        org.geotools.parameter.Parameters.copy(parameters, copy);
        return block;
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) throws CoverageProcessingException {
        ParameterBlockJAI block = this.prepareParameters(parameters);
        String[] sourceNames = this.operation.getSourceNames();
        GridCoverage2D[] sources = new GridCoverage2D[sourceNames.length];
        ViewType primarySourceType = this.extractSources(parameters, sourceNames, sources);
        this.resampleToCommonGeometry(sources, null, null, hints);
        GridCoverage2D coverage = sources[0];
        CoordinateReferenceSystem crs = coverage.getCoordinateReferenceSystem2D();
        MathTransform2D gridToCRS = coverage.getGridGeometry().getGridToCRS2D();
        for (int i = 0; i < sources.length; ++i) {
            GridCoverage2D source = sources[i];
            if (!CRS.equalsIgnoreMetadata(crs, source.getCoordinateReferenceSystem2D()) || !CRS.equalsIgnoreMetadata(gridToCRS, source.getGridGeometry().getGridToCRS2D())) {
                throw new IllegalArgumentException(Errors.format((int)75));
            }
            block.setSource(sourceNames[i], (Object)source.getRenderedImage());
        }
        coverage = this.deriveGridCoverage(sources, new Parameters(crs, gridToCRS, block, hints));
        return OperationJAI.postProcessResult(coverage, primarySourceType);
    }

    private static GridCoverage2D postProcessResult(GridCoverage2D coverage, ViewType primarySourceType) {
        if (primarySourceType != null) {
            coverage = coverage.view(primarySourceType);
        }
        return coverage;
    }

    private static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem crs, int lower, int upper) throws InvalidGridGeometryException {
        if (lower == upper) {
            return null;
        }
        CoordinateReferenceSystem candidate = CRSUtilities.getSubCRS(crs, lower, upper);
        if (candidate == null) {
            throw new InvalidGridGeometryException("Unsupported CRS: " + crs.getName().getCode());
        }
        return candidate;
    }

    private static void ensureStableDimensions(DimensionFilter filter) throws InvalidGridGeometryException {
        int[] source = filter.getSourceDimensions();
        Arrays.sort(source);
        int[] target = filter.getTargetDimensions();
        Arrays.sort(target);
        if (!Arrays.equals(source, target)) {
            throw new InvalidGridGeometryException("Unsupported math transform.");
        }
    }

    protected void resampleToCommonGeometry(GridCoverage2D[] sources, CoordinateReferenceSystem crs2D, MathTransform2D gridToCrs2D, Hints hints) throws InvalidGridGeometryException, CannotReprojectException {
        if (sources == null || sources.length == 0) {
            return;
        }
        GridCoverage2D primarySource = sources[0];
        if (crs2D == null) {
            if (gridToCrs2D == null && sources.length == 1) {
                return;
            }
            crs2D = primarySource.getCoordinateReferenceSystem2D();
        } else {
            try {
                crs2D = CRSUtilities.getCRS2D(crs2D);
            }
            catch (TransformException exception) {
                throw new CannotReprojectException("Unsupported CRS: " + crs2D.getName().getCode());
            }
        }
        if (gridToCrs2D == null) {
            gridToCrs2D = primarySource.getGridGeometry().getGridToCRS2D();
        }
        AbstractProcessor processor = OperationJAI.getProcessor((RenderingHints)hints);
        for (int i = 0; i < sources.length; ++i) {
            MathTransform toTarget;
            Object targetCRS;
            GridCoverage2D source = sources[i];
            GridGeometry2D geometry = source.getGridGeometry();
            CoordinateReferenceSystem srcCrs2D = source.getCoordinateReferenceSystem2D();
            CoordinateReferenceSystem sourceCRS = source.getCoordinateReferenceSystem();
            if (CRS.equalsIgnoreMetadata(crs2D, srcCrs2D)) {
                targetCRS = sourceCRS;
            } else {
                int lowerDim = Math.min(geometry.axisDimensionX, geometry.axisDimensionY);
                int upperDim = Math.max(geometry.axisDimensionX, geometry.axisDimensionY) + 1;
                int sourceDim = sourceCRS.getCoordinateSystem().getDimension();
                if (upperDim - lowerDim != srcCrs2D.getCoordinateSystem().getDimension()) {
                    throw new InvalidGridGeometryException("Unsupported CRS: " + sourceCRS.getName().getCode());
                }
                CoordinateReferenceSystem headCRS = OperationJAI.getSubCRS(sourceCRS, 0, lowerDim);
                CoordinateReferenceSystem tailCRS = OperationJAI.getSubCRS(sourceCRS, upperDim, sourceDim);
                Object[] components = new CoordinateReferenceSystem[3];
                int count = 0;
                if (headCRS != null) {
                    components[count++] = headCRS;
                }
                components[count++] = crs2D;
                if (tailCRS != null) {
                    components[count++] = tailCRS;
                }
                components = (CoordinateReferenceSystem[])XArray.resize((Object[])components, (int)count);
                if (count == 1) {
                    targetCRS = components[0];
                } else {
                    try {
                        targetCRS = ReferencingFactoryFinder.getCRSFactory(hints).createCompoundCRS(Collections.singletonMap("name", crs2D.getName().getCode()), (CoordinateReferenceSystem[])components);
                    }
                    catch (FactoryException exception) {
                        throw new CannotReprojectException(exception.getLocalizedMessage(), exception);
                    }
                }
            }
            MathTransform2D toSource2D = geometry.getGridToCRS2D();
            MathTransform toSource = geometry.getGridToCRS();
            if (CRS.equalsIgnoreMetadata(gridToCrs2D, toSource2D)) {
                toTarget = toSource;
            } else {
                int lowerDim = Math.min(geometry.gridDimensionX, geometry.gridDimensionY);
                int upperDim = Math.max(geometry.gridDimensionX, geometry.gridDimensionY) + 1;
                int sourceDim = toSource.getSourceDimensions();
                if (upperDim - lowerDim != toSource2D.getSourceDimensions()) {
                    throw new InvalidGridGeometryException("Unsupported math transform.");
                }
                MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(hints);
                DimensionFilter filter = new DimensionFilter(factory);
                toTarget = gridToCrs2D;
                try {
                    MathTransform step;
                    if (lowerDim != 0) {
                        filter.addSourceDimensionRange(0, lowerDim);
                        step = filter.separate(toSource);
                        OperationJAI.ensureStableDimensions(filter);
                        step = factory.createPassThroughTransform(0, step, sourceDim - lowerDim);
                        toTarget = factory.createConcatenatedTransform(step, toTarget);
                    }
                    if (upperDim != sourceDim) {
                        filter.clear();
                        filter.addSourceDimensionRange(upperDim, sourceDim);
                        step = filter.separate(toSource);
                        OperationJAI.ensureStableDimensions(filter);
                        step = factory.createPassThroughTransform(upperDim, step, 0);
                        toTarget = factory.createConcatenatedTransform(toTarget, step);
                    }
                }
                catch (FactoryException exception) {
                    throw new CannotReprojectException(Errors.format((int)30, (Object)source.getName()), exception);
                }
            }
            GridGeometry2D targetGeom = new GridGeometry2D(null, toTarget, (CoordinateReferenceSystem)targetCRS);
            ParameterValueGroup param = processor.getOperation("Resample").getParameters();
            param.parameter("Source").setValue((Object)source);
            param.parameter("GridGeometry").setValue((Object)targetGeom);
            param.parameter("CoordinateReferenceSystem").setValue(targetCRS);
            sources[i] = (GridCoverage2D)processor.doOperation(param);
        }
    }

    protected GridCoverage2D deriveGridCoverage(GridCoverage2D[] sources, Parameters parameters) {
        RenderingHints hints;
        ImageLayout layout;
        GridCoverage2D primarySource = sources[0];
        GridSampleDimension[][] list = new GridSampleDimension[sources.length][];
        for (int i = 0; i < list.length; ++i) {
            list[i] = sources[i].getSampleDimensions();
        }
        Object[] sampleDims = this.deriveSampleDimension(list, parameters);
        int primarySourceIndex = -1;
        for (int i = 0; i < list.length; ++i) {
            if (!Arrays.equals(sampleDims, list[i])) continue;
            primarySource = sources[i];
            primarySourceIndex = i;
            break;
        }
        ImageLayout imageLayout = layout = (hints = ImageUtilities.getRenderingHints(parameters.getSource())) != null ? (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT) : null;
        if (!(layout != null && layout.isValid(512) || sampleDims == null || sampleDims.length == 0)) {
            ColorModel colors;
            int visibleBand = CoverageUtilities.getVisibleBand(primarySource.getRenderedImage());
            if (visibleBand >= sampleDims.length) {
                visibleBand = 0;
            }
            if ((colors = ((GridSampleDimension)sampleDims[visibleBand]).getColorModel(visibleBand, sampleDims.length)) != null) {
                if (layout == null) {
                    layout = new ImageLayout();
                }
                layout = layout.setColorModel(colors);
            }
        }
        if (layout != null) {
            if (hints == null) {
                hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            } else {
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            }
        }
        if (parameters.hints != null) {
            if (hints != null) {
                hints.add((RenderingHints)parameters.hints);
            } else {
                hints = parameters.hints;
            }
        }
        InternationalString name = this.deriveName(sources, primarySourceIndex, parameters);
        CoordinateReferenceSystem crs = primarySource.getCoordinateReferenceSystem();
        MathTransform toCRS = primarySource.getGridGeometry().getGridToCRS();
        RenderedImage data = this.createRenderedImage(parameters.parameters, hints);
        Map<String, ?> properties = this.getProperties(data, crs, name, toCRS, sources, parameters);
        return OperationJAI.getFactory(parameters.hints).create((CharSequence)name, data, crs, toCRS, (GridSampleDimension[])sampleDims, sources, properties);
    }

    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, Parameters parameters) {
        return null;
    }

    protected static int getQuantitative(Category[] categories) {
        int index = -1;
        for (int i = 0; i < categories.length; ++i) {
            if (!categories[i].isQuantitative()) continue;
            if (index >= 0) {
                return -1;
            }
            index = i;
        }
        return index;
    }

    protected GridSampleDimension[] deriveSampleDimension(GridSampleDimension[][] bandLists, Parameters parameters) {
        int numBands = 1;
        for (int i = 0; i < bandLists.length; ++i) {
            int nb = bandLists[i].length;
            if (nb == 1) continue;
            if (numBands != 1 && nb != numBands) {
                return null;
            }
            numBands = nb;
        }
        GridSampleDimension[] result = new GridSampleDimension[numBands];
        Category[] categoryXS = new Category[bandLists.length];
        Unit[] unitXS = new Unit[bandLists.length];
        while (--numBands >= 0) {
            GridSampleDimension sampleDim = null;
            Category[] categoryArray = null;
            int indexOfQuantitative = 0;
            int i = bandLists.length;
            while (--i >= 0) {
                GridSampleDimension[] allBands;
                sampleDim = allBands[(allBands = bandLists[i]).length == 1 ? 0 : numBands];
                List<Category> categories = sampleDim.getCategories();
                if (categories == null || categories.isEmpty()) {
                    result[numBands] = sampleDim;
                    continue;
                }
                categoryArray = (Category[])categories.toArray();
                indexOfQuantitative = OperationJAI.getQuantitative(categoryArray);
                if (indexOfQuantitative < 0) {
                    return null;
                }
                unitXS[i] = sampleDim.getUnits();
                categoryXS[i] = categoryArray[indexOfQuantitative];
            }
            if (categoryArray == null) continue;
            void oldCategory = categoryArray[indexOfQuantitative];
            Unit<?> oldUnit = sampleDim.getUnits();
            Category newCategory = this.deriveCategory(categoryXS, parameters);
            Unit<?> newUnit = this.deriveUnit(unitXS, parameters);
            if (newCategory == null) {
                return null;
            }
            if (!oldCategory.equals(newCategory) || !Utilities.equals(oldUnit, newUnit)) {
                CharSequence title = null;
                categoryArray[indexOfQuantitative] = newCategory;
                result[numBands] = new GridSampleDimension(title, categoryArray, newUnit);
                continue;
            }
            result[numBands] = sampleDim;
        }
        return result;
    }

    protected Category deriveCategory(Category[] categories, Parameters parameters) {
        NumberRange[] ranges = new NumberRange[categories.length];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = categories[i].getRange();
        }
        NumberRange range = this.deriveRange(ranges, parameters);
        if (range != null) {
            Category category = categories[0];
            return new Category((CharSequence)category.getName(), category.getColors(), category.geophysics(false).getRange(), range).geophysics(true);
        }
        return null;
    }

    protected NumberRange deriveRange(NumberRange[] ranges, Parameters parameters) {
        return null;
    }

    protected Unit<?> deriveUnit(Unit<?>[] units, Parameters parameters) {
        return null;
    }

    protected InternationalString deriveName(GridCoverage2D[] sources, int primarySourceIndex, Parameters parameters) {
        InternationalString[] names;
        if (primarySourceIndex >= 0) {
            names = new InternationalString[]{sources[primarySourceIndex].getName()};
        } else {
            names = new InternationalString[sources.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = sources[i].getName();
            }
        }
        return new Name(this.getName(), names);
    }

    protected RenderedImage createRenderedImage(ParameterBlockJAI parameters, RenderingHints hints) {
        return OperationJAI.getJAI(hints).createNS(this.operation.getName(), (ParameterBlock)parameters, hints);
    }

    public static final JAI getJAI(RenderingHints hints) {
        Object value;
        if (hints != null && (value = hints.get(Hints.JAI_INSTANCE)) instanceof JAI) {
            return (JAI)value;
        }
        return JAI.getDefaultInstance();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            OperationJAI that = (OperationJAI)object;
            return Utilities.equals((Object)this.operation, (Object)that.operation);
        }
        return false;
    }

    protected static final class Parameters {
        public final CoordinateReferenceSystem crs;
        public final MathTransform2D gridToCRS;
        public final ParameterBlockJAI parameters;
        public final Hints hints;

        Parameters(CoordinateReferenceSystem crs, MathTransform2D gridToCRS, ParameterBlockJAI parameters, Hints hints) {
            this.crs = crs;
            this.gridToCRS = gridToCRS;
            this.parameters = parameters;
            this.hints = hints;
        }

        final RenderedImage getSource() {
            int n = this.parameters.getNumSources();
            for (int i = 0; i < n; ++i) {
                Object source = this.parameters.getSource(i);
                if (!(source instanceof RenderedImage)) continue;
                return (RenderedImage)source;
            }
            return null;
        }
    }

    private static final class Name
    extends AbstractInternationalString
    implements Serializable {
        private static final long serialVersionUID = -8096255331549347383L;
        private final String operation;
        private final InternationalString[] sources;

        public Name(String operation, InternationalString[] sources) {
            this.operation = operation;
            this.sources = sources;
        }

        public String toString(Locale locale) {
            StringBuilder buffer = new StringBuilder(this.operation);
            buffer.append('(');
            for (int i = 0; i < this.sources.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.sources[i].toString(locale));
            }
            return buffer.append(')').toString();
        }
    }
}

