/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.h2.command.Command;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.h2.engine.Procedure;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionWithState;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.jdbc.JdbcConnection;
import org.h2.log.InDoubtTransaction;
import org.h2.log.LogSystem;
import org.h2.log.UndoLog;
import org.h2.log.UndoLogRecord;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.store.DataHandler;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
extends SessionWithState {
    private static final String SYSTEM_IDENTIFIER_PREFIX = "_";
    private static int nextSerialId;
    private final int serialId = nextSerialId++;
    private Database database;
    private ConnectionInfo connectionInfo;
    private User user;
    private int id;
    private ObjectArray<Table> locks = ObjectArray.newInstance();
    private UndoLog undoLog;
    private boolean autoCommit = true;
    private Random random;
    private LogSystem logSystem;
    private int lockTimeout;
    private Value lastIdentity = ValueLong.get(0L);
    private int firstUncommittedLog = -1;
    private int firstUncommittedPos = -1;
    private HashMap<String, Integer> savepoints;
    private Exception stackTrace = new Exception();
    private HashMap<String, Table> localTempTables;
    private HashMap<String, Index> localTempTableIndexes;
    private HashMap<String, Constraint> localTempTableConstraints;
    private int throttle;
    private long lastThrottle;
    private Command currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String[] schemaSearchPath;
    private String traceModuleName;
    private HashMap<String, ValueLob> unlinkMap;
    private int systemIdentifier;
    private HashMap<String, Procedure> procedures;
    private boolean undoLogEnabled = true;
    private boolean autoCommitAtTransactionEnd;
    private String currentTransactionName;
    private volatile long cancelAt;
    private boolean closed;
    private long sessionStart = System.currentTimeMillis();
    private long currentCommandStart;
    private HashMap<String, Value> variables;
    private HashSet<LocalResult> temporaryResults;
    private int queryTimeout = SysProperties.getMaxQueryTimeout();
    private int lastUncommittedDelete;
    private boolean commitOrRollbackDisabled;
    private Table waitForLock;
    private int modificationId;
    private int modificationIdState;
    private int objectId;

    public Session(Database database, User user, int n) {
        this.database = database;
        this.undoLog = new UndoLog(this);
        this.user = user;
        this.id = n;
        this.logSystem = database.getLog();
        Setting setting = database.findSetting(SetTypes.getTypeName(6));
        this.lockTimeout = setting == null ? 2000 : setting.getIntValue();
        this.currentSchemaName = "PUBLIC";
    }

    public boolean setCommitOrRollbackDisabled(boolean bl) {
        boolean bl2 = this.commitOrRollbackDisabled;
        this.commitOrRollbackDisabled = bl;
        return bl2;
    }

    private void initVariables() {
        if (this.variables == null) {
            this.variables = New.hashMap();
        }
    }

    public void setVariable(String string, Value value) throws SQLException {
        Value value2;
        this.initVariables();
        ++this.modificationId;
        if (value == ValueNull.INSTANCE) {
            value2 = this.variables.remove(string);
        } else {
            if (value instanceof ValueLob) {
                value = value.link(this.database, -1);
            }
            value2 = this.variables.put(string, value);
        }
        if (value2 != null) {
            value2.unlink();
            value2.close();
        }
    }

    public Value getVariable(String string) {
        this.initVariables();
        Value value = this.variables.get(string);
        return value == null ? ValueNull.INSTANCE : value;
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.variables.size()];
        this.variables.keySet().toArray(stringArray);
        return stringArray;
    }

    public Table findLocalTempTable(String string) {
        if (this.localTempTables == null) {
            return null;
        }
        return this.localTempTables.get(string);
    }

    public ObjectArray<Table> getLocalTempTables() {
        if (this.localTempTables == null) {
            return ObjectArray.newInstance();
        }
        return ObjectArray.newInstance(this.localTempTables.values());
    }

    public void addLocalTempTable(Table table) throws SQLException {
        if (this.localTempTables == null) {
            this.localTempTables = New.hashMap();
        }
        if (this.localTempTables.get(table.getName()) != null) {
            throw Message.getSQLException(42101, table.getSQL());
        }
        ++this.modificationId;
        this.localTempTables.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTable(Table table) throws SQLException {
        ++this.modificationId;
        this.localTempTables.remove(table.getName());
        Database database = this.database;
        synchronized (database) {
            table.removeChildrenAndResources(this);
        }
    }

    public Index findLocalTempTableIndex(String string) {
        if (this.localTempTableIndexes == null) {
            return null;
        }
        return this.localTempTableIndexes.get(string);
    }

    public HashMap<String, Index> getLocalTempTableIndexes() {
        if (this.localTempTableIndexes == null) {
            return New.hashMap();
        }
        return this.localTempTableIndexes;
    }

    public void addLocalTempTableIndex(Index index) throws SQLException {
        if (this.localTempTableIndexes == null) {
            this.localTempTableIndexes = New.hashMap();
        }
        if (this.localTempTableIndexes.get(index.getName()) != null) {
            throw Message.getSQLException(42111, index.getSQL());
        }
        this.localTempTableIndexes.put(index.getName(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableIndex(Index index) throws SQLException {
        if (this.localTempTableIndexes != null) {
            this.localTempTableIndexes.remove(index.getName());
            Database database = this.database;
            synchronized (database) {
                index.removeChildrenAndResources(this);
            }
        }
    }

    public Constraint findLocalTempTableConstraint(String string) {
        if (this.localTempTableConstraints == null) {
            return null;
        }
        return this.localTempTableConstraints.get(string);
    }

    public HashMap<String, Constraint> getLocalTempTableConstraints() {
        if (this.localTempTableConstraints == null) {
            return New.hashMap();
        }
        return this.localTempTableConstraints;
    }

    public void addLocalTempTableConstraint(Constraint constraint) throws SQLException {
        String string;
        if (this.localTempTableConstraints == null) {
            this.localTempTableConstraints = New.hashMap();
        }
        if (this.localTempTableConstraints.get(string = constraint.getName()) != null) {
            throw Message.getSQLException(90045, constraint.getSQL());
        }
        this.localTempTableConstraints.put(string, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableConstraint(Constraint constraint) throws SQLException {
        if (this.localTempTableConstraints != null) {
            this.localTempTableConstraints.remove(constraint.getName());
            Database database = this.database;
            synchronized (database) {
                constraint.removeChildrenAndResources(this);
            }
        }
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        if (!this.closed) {
            throw Message.getInternalError("not closed", this.stackTrace);
        }
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int n) {
        this.lockTimeout = n;
    }

    @Override
    public CommandInterface prepareCommand(String string, int n) throws SQLException {
        return this.prepareLocal(string);
    }

    public Prepared prepare(String string) throws SQLException {
        return this.prepare(string, false);
    }

    public Prepared prepare(String string, boolean bl) throws SQLException {
        Parser parser = new Parser(this);
        parser.setRightsChecked(bl);
        return parser.prepare(string);
    }

    public Command prepareLocal(String string) throws SQLException {
        if (this.closed) {
            throw Message.getSQLException(90067);
        }
        Parser parser = new Parser(this);
        return parser.prepareCommand(string);
    }

    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getPowerOffCount() {
        return this.database.getPowerOffCount();
    }

    @Override
    public void setPowerOffCount(int n) {
        this.database.setPowerOffCount(n);
    }

    public int getLastUncommittedDelete() {
        return this.lastUncommittedDelete;
    }

    public void setLastUncommittedDelete(int n) {
        this.lastUncommittedDelete = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean bl) throws SQLException {
        this.checkCommitRollback();
        this.lastUncommittedDelete = 0;
        this.currentTransactionName = null;
        if (this.containsUncommitted()) {
            this.logSystem.commit(this);
        }
        if (this.undoLog.size() > 0) {
            ArrayList arrayList = New.arrayList();
            Database object = this.database;
            synchronized (object) {
                Object object2;
                while (this.undoLog.size() > 0) {
                    object2 = this.undoLog.getLast();
                    ((UndoLogRecord)object2).commit();
                    arrayList.add(((UndoLogRecord)object2).getRow());
                    this.undoLog.removeLast(false);
                }
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    Row row = (Row)object2.next();
                    row.commit();
                }
            }
            this.undoLog.clear();
        }
        if (!bl) {
            this.cleanTempTables(false);
            if (this.autoCommitAtTransactionEnd) {
                this.autoCommit = true;
                this.autoCommitAtTransactionEnd = false;
            }
        }
        if (this.unlinkMap != null && this.unlinkMap.size() > 0) {
            this.logSystem.flush();
            for (ValueLob valueLob : this.unlinkMap.values()) {
                ((Value)valueLob).unlink();
            }
            this.unlinkMap = null;
        }
        this.unlockAll();
    }

    private void checkCommitRollback() throws SQLException {
        if (this.commitOrRollbackDisabled && this.locks.size() > 0) {
            throw Message.getSQLException(90058);
        }
    }

    public void rollback() throws SQLException {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        boolean bl = false;
        if (this.undoLog.size() > 0) {
            this.rollbackTo(0, false);
            bl = true;
        }
        if (this.locks.size() > 0 || bl) {
            this.logSystem.commit(this);
        }
        this.cleanTempTables(false);
        this.unlockAll();
        if (this.autoCommitAtTransactionEnd) {
            this.autoCommit = true;
            this.autoCommitAtTransactionEnd = false;
        }
    }

    public void rollbackTo(int n, boolean bl) throws SQLException {
        String[] stringArray;
        while (this.undoLog.size() > n) {
            stringArray = this.undoLog.getLast();
            stringArray.undo(this);
            this.undoLog.removeLast(bl);
        }
        if (this.savepoints != null) {
            stringArray = new String[this.savepoints.size()];
            this.savepoints.keySet().toArray(stringArray);
            for (String string : stringArray) {
                Integer n2 = this.savepoints.get(string);
                if (n2 <= n) continue;
                this.savepoints.remove(string);
            }
        }
    }

    public int getLogId() {
        return this.undoLog.size();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        this.cancelAt = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            try {
                this.cleanTempTables(true);
                this.database.removeSession(this);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public void addLock(Table table) {
        if (SysProperties.CHECK && this.locks.indexOf(table) >= 0) {
            Message.throwInternalError();
        }
        this.locks.add(table);
    }

    public void log(Table table, short s, Row row) throws SQLException {
        this.log(new UndoLogRecord(table, s, row));
    }

    private void log(UndoLogRecord undoLogRecord) throws SQLException {
        int n;
        if (SysProperties.CHECK && (n = this.database.getLockMode()) != 0 && !this.database.isMultiVersion() && this.locks.indexOf(undoLogRecord.getTable()) < 0 && !"TABLE LINK".equals(undoLogRecord.getTable().getTableType())) {
            Message.throwInternalError();
        }
        if (this.undoLogEnabled) {
            this.undoLog.add(undoLogRecord);
        } else {
            undoLogRecord.commit();
            undoLogRecord.getRow().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockReadLocks() {
        if (this.database.isMultiVersion()) {
            return;
        }
        for (int i = 0; i < this.locks.size(); ++i) {
            Table table = this.locks.get(i);
            if (table.isLockedExclusively()) continue;
            Database database = this.database;
            synchronized (database) {
                table.unlock(this);
                this.locks.remove(i);
            }
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockAll() {
        if (SysProperties.CHECK && this.undoLog.size() > 0) {
            Message.throwInternalError();
        }
        if (this.locks.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                for (Table table : this.locks) {
                    table.unlock(this);
                }
                this.locks.clear();
            }
        }
        this.savepoints = null;
        if (this.modificationIdState != this.modificationId) {
            this.sessionStateChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTempTables(boolean bl) throws SQLException {
        if (this.localTempTables != null && this.localTempTables.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                for (Table table : ObjectArray.newInstance(this.localTempTables.values())) {
                    if (bl || table.getOnCommitDrop()) {
                        ++this.modificationId;
                        table.setModified();
                        this.localTempTables.remove(table.getName());
                        table.removeChildrenAndResources(this);
                        continue;
                    }
                    if (!table.getOnCommitTruncate()) continue;
                    table.truncate(this);
                }
            }
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    @Override
    public Trace getTrace() {
        if (this.traceModuleName == null) {
            this.traceModuleName = "jdbc[" + this.id + "]";
        }
        if (this.closed) {
            return new TraceSystem(null, false).getTrace(this.traceModuleName);
        }
        return this.database.getTrace(this.traceModuleName);
    }

    public void setLastIdentity(Value value) {
        this.lastIdentity = value;
    }

    public Value getLastIdentity() {
        return this.lastIdentity;
    }

    public void addLogPos(int n, int n2) {
        if (this.firstUncommittedLog == -1) {
            this.firstUncommittedLog = n;
            this.firstUncommittedPos = n2;
        }
    }

    public int getFirstUncommittedLog() {
        return this.firstUncommittedLog;
    }

    public int getFirstUncommittedPos() {
        return this.firstUncommittedPos;
    }

    public void setAllCommitted() {
        this.firstUncommittedLog = -1;
        this.firstUncommittedPos = -1;
    }

    private boolean containsUncommitted() {
        return this.firstUncommittedLog != -1;
    }

    public void addSavepoint(String string) {
        if (this.savepoints == null) {
            this.savepoints = New.hashMap();
        }
        this.savepoints.put(string, this.getLogId());
    }

    public void rollbackToSavepoint(String string) throws SQLException {
        this.checkCommitRollback();
        if (this.savepoints == null) {
            throw Message.getSQLException(90063, string);
        }
        Integer n = this.savepoints.get(string);
        if (n == null) {
            throw Message.getSQLException(90063, string);
        }
        int n2 = n;
        this.rollbackTo(n2, false);
    }

    public void prepareCommit(String string) throws SQLException {
        if (this.containsUncommitted()) {
            this.logSystem.prepareCommit(this, string);
        }
        this.currentTransactionName = string;
    }

    public void setPreparedTransaction(String string, boolean bl) throws SQLException {
        if (this.currentTransactionName != null && this.currentTransactionName.equals(string)) {
            if (bl) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ObjectArray<InDoubtTransaction> objectArray = this.logSystem.getInDoubtTransactions();
            int n = bl ? 1 : 2;
            boolean bl2 = false;
            for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
                InDoubtTransaction inDoubtTransaction = objectArray.get(i);
                if (!inDoubtTransaction.getTransaction().equals(string)) continue;
                inDoubtTransaction.setState(n);
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw Message.getSQLException(90129, string);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setThrottle(int n) {
        this.throttle = n;
    }

    public void throttle() {
        if (this.throttle == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.lastThrottle + 50L > l) {
            return;
        }
        this.lastThrottle = l + (long)this.throttle;
        try {
            Thread.sleep(this.throttle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentCommand(Command command, long l) {
        this.currentCommand = command;
        this.currentCommandStart = l;
        if (this.queryTimeout > 0 && l != 0L) {
            this.cancelAt = l + (long)this.queryTimeout;
        }
    }

    public void checkCanceled() throws SQLException {
        this.throttle();
        if (this.cancelAt == 0L) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l >= this.cancelAt) {
            this.cancelAt = 0L;
            throw Message.getSQLException(90051);
        }
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public long getCurrentCommandStart() {
        return this.currentCommandStart;
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean bl) {
        this.allowLiterals = bl;
    }

    public void setCurrentSchema(Schema schema) {
        ++this.modificationId;
        this.currentSchemaName = schema.getName();
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public JdbcConnection createConnection(boolean bl) {
        String string = bl ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), string);
    }

    @Override
    public DataHandler getDataHandler() {
        return this.database;
    }

    public void unlinkAtCommit(ValueLob valueLob) {
        if (SysProperties.CHECK && !valueLob.isLinked()) {
            Message.throwInternalError();
        }
        if (this.unlinkMap == null) {
            this.unlinkMap = New.hashMap();
        }
        this.unlinkMap.put(valueLob.toString(), valueLob);
    }

    public void unlinkAtCommitStop(Value value) {
        if (this.unlinkMap != null) {
            this.unlinkMap.remove(value.toString());
        }
    }

    public String getNextSystemIdentifier(String string) {
        String string2;
        while (string.indexOf(string2 = SYSTEM_IDENTIFIER_PREFIX + this.systemIdentifier++) >= 0) {
        }
        return string2;
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures == null) {
            this.procedures = New.hashMap();
        }
        this.procedures.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String string) {
        if (this.procedures != null) {
            this.procedures.remove(string);
        }
    }

    public Procedure getProcedure(String string) {
        if (this.procedures == null) {
            return null;
        }
        return this.procedures.get(string);
    }

    public void setSchemaSearchPath(String[] stringArray) {
        ++this.modificationId;
        this.schemaSearchPath = stringArray;
    }

    public String[] getSchemaSearchPath() {
        return this.schemaSearchPath;
    }

    public int hashCode() {
        return this.serialId;
    }

    public String toString() {
        return "#" + this.serialId + " (user: " + this.user.getName() + ")";
    }

    public void setUndoLogEnabled(boolean bl) {
        this.undoLogEnabled = bl;
    }

    public boolean isUndoLogEnabled() {
        return this.undoLogEnabled;
    }

    public void begin() {
        this.autoCommitAtTransactionEnd = true;
        this.autoCommit = false;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table[] getLocks() {
        Database database = this.database;
        synchronized (database) {
            Object[] objectArray = new Table[this.locks.size()];
            this.locks.toArray(objectArray);
            return objectArray;
        }
    }

    public void waitIfExclusiveModeEnabled() {
        Session session;
        while ((session = this.database.getExclusiveSession()) != null && session != this) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addTemporaryResult(LocalResult localResult) {
        if (!localResult.needToClose()) {
            return;
        }
        if (this.temporaryResults == null) {
            this.temporaryResults = New.hashSet();
        }
        if (this.temporaryResults.size() < 100) {
            this.temporaryResults.add(localResult);
        }
    }

    public void closeTemporaryResults() {
        if (this.temporaryResults != null) {
            for (LocalResult localResult : this.temporaryResults) {
                localResult.close();
            }
            this.temporaryResults = null;
        }
    }

    public void setQueryTimeout(int n) {
        int n2 = SysProperties.getMaxQueryTimeout();
        if (n2 != 0 && (n2 < n || n == 0)) {
            n = n2;
        }
        this.queryTimeout = n;
        this.cancelAt = 0L;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setWaitForLock(Table table) {
        this.waitForLock = table;
    }

    public Table getWaitForLock() {
        return this.waitForLock;
    }

    public int getModificationId() {
        return this.modificationId;
    }

    @Override
    public boolean isReconnectNeeded(boolean bl) {
        block2: {
            do {
                boolean bl2;
                if (bl2 = this.database.isReconnectNeeded()) {
                    return true;
                }
                if (!bl) break block2;
            } while (!this.database.beforeWriting());
            return false;
        }
        return false;
    }

    @Override
    public SessionInterface reconnect() throws SQLException {
        this.readSessionState();
        this.close();
        Session session = Engine.getInstance().getSession(this.connectionInfo);
        session.sessionState = this.sessionState;
        session.recreateSessionState();
        return session;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public Value getTransactionId() {
        if (this.undoLog.size() == 0 || !this.database.isPersistent()) {
            return ValueNull.INSTANCE;
        }
        return ValueString.get(this.firstUncommittedLog + "-" + this.firstUncommittedPos + "-" + this.id);
    }

    public int nextObjectId() {
        return this.objectId++;
    }
}

