/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.net.URL;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;

class ShpFilesLocker {
    final URL url;
    final FileReader reader;
    final FileWriter writer;
    boolean upgraded;
    private Trace trace;

    public ShpFilesLocker(URL url, FileReader reader) {
        this.url = url;
        this.reader = reader;
        this.writer = null;
        ShapefileDataStoreFactory.LOGGER.fine("Read lock: " + url + " by " + reader.id());
        this.setTraceException();
    }

    public ShpFilesLocker(URL url, FileWriter writer) {
        this.url = url;
        this.reader = null;
        this.writer = writer;
        ShapefileDataStoreFactory.LOGGER.fine("Write lock: " + url + " by " + writer.id());
        this.setTraceException();
    }

    private void setTraceException() {
        String id;
        String type;
        String name = Thread.currentThread().getName();
        if (this.reader != null) {
            type = "read";
            id = this.reader.id();
        } else {
            type = "write";
            id = this.writer.id();
        }
        this.trace = new Trace("Locking " + this.url + " for " + type + " by " + id + " in thread " + name);
    }

    public Exception getTrace() {
        return this.trace;
    }

    public void compare(URL url2, Object requestor) {
        URL url = this.url;
        assert (url2 == url) : "Expected: " + url + " but got: " + url2;
        assert (this.reader == null || requestor == this.reader) : "Expected the requestor and the reader to be the same object: " + this.reader.id();
        assert (this.writer == null || requestor == this.writer) : "Expected the requestor and the writer to be the same object: " + this.writer.id();
    }

    public String toString() {
        if (this.reader != null) {
            return "read on " + this.url + " by " + this.reader.id();
        }
        return "write on " + this.url + " by " + this.writer.id();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reader == null ? 0 : this.reader.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.writer == null ? 0 : this.writer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShpFilesLocker other = (ShpFilesLocker)obj;
        if (this.reader == null ? other.reader != null : !this.reader.equals(other.reader)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.writer == null ? other.writer != null : !this.writer.equals(other.writer));
    }

    private static class Trace
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Trace(String message) {
            super(message);
        }
    }
}

