/*
 * Decompiled with CFR 0.152.
 */
package simple.util.schedule;

import simple.util.schedule.Registry;
import simple.util.schedule.SchedulerQueue;

public class Scheduler {
    protected static final long DEFAULT_MAX = 120000L;
    protected SchedulerQueue queue = new SchedulerQueue();
    protected Registry registry = new Registry();
    protected long max;
    private long start = this.currentTime();

    public Scheduler() {
        this(120000L);
    }

    public Scheduler(long max) {
        this.max = max;
    }

    public void enqueue(Object object, long wait) {
        long timeout = Math.min(wait, this.max) + this.currentTime();
        Entry entry = new Entry();
        entry.object = object;
        entry.timeout = timeout;
        this.enqueue(entry);
        this.interrupt(entry);
    }

    protected void interrupt(Entry entry) {
        this.registry.interrupt(entry.timeout);
    }

    protected void enqueue(Entry entry) {
        long wait = entry.timeout;
        long minus = -1L * wait;
        this.queue.enqueue(entry, minus);
    }

    public Object dequeue() throws InterruptedException {
        while (true) {
            Object top = this.queue.dequeue();
            Entry entry = (Entry)top;
            try {
                this.sleep(entry.timeout);
                return entry.object;
            }
            catch (InterruptedException e) {
                this.enqueue(entry);
                continue;
            }
            break;
        }
    }

    protected void unregister() {
        this.registry.remove();
    }

    protected void register(long awaken) {
        this.registry.sleeping(awaken);
    }

    protected void sleep(long awaken) throws InterruptedException {
        try {
            long time = this.currentTime();
            long sleep = awaken - time;
            if (sleep <= 0L) {
                return;
            }
            this.register(awaken);
            Thread.sleep(sleep);
        }
        finally {
            this.unregister();
        }
    }

    protected long currentTime() {
        return System.currentTimeMillis() - this.start;
    }

    public class Entry {
        public Object object;
        public long timeout;
    }
}

