/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Font;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.expression.Expression;
import org.picocontainer.MutablePicoContainer;

public class SLDFontBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDFontBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.FONT;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Font.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Expression family = null;
        Expression style = null;
        Expression weight = null;
        Expression size = null;
        for (CssParameter css : node.getChildValues("CssParameter")) {
            if (css.getExpressions().isEmpty()) continue;
            if ("font-family".equals(css.getName())) {
                family = (Expression)css.getExpressions().get(0);
            }
            if ("font-style".equals(css.getName())) {
                style = (Expression)css.getExpressions().get(0);
            }
            if ("font-weight".equals(css.getName())) {
                weight = (Expression)css.getExpressions().get(0);
            }
            if (!"font-size".equals(css.getName())) continue;
            size = (Expression)css.getExpressions().get(0);
        }
        return this.styleFactory.createFont(family, style, weight, size);
    }
}

