/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.FunctionExpressionImpl;
import org.opengis.filter.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvFunction
extends FunctionExpressionImpl {
    private static final LocalLookup localLookup = new LocalLookup();
    private static ConcurrentMap<String, Object> globalLookup = new ConcurrentHashMap<String, Object>();

    public EnvFunction() {
        super("env");
    }

    public static void setLocalValues(Map<String, Object> values) {
        Map<String, Object> table = localLookup.getTable();
        table.clear();
        if (values != null) {
            table.putAll(values);
        }
    }

    public static void setGlobalValues(Map<String, Object> values) {
        globalLookup.clear();
        if (values != null) {
            globalLookup.putAll(values);
        }
    }

    public static void setLocalValue(String name, Object value) {
        localLookup.getTable().put(name, value);
    }

    public static void setGlobalValue(String name, Object value) {
        globalLookup.put(name, value);
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    @Override
    public Object evaluate(Object feature) {
        int paramSize;
        String varName = (String)this.getExpression(0).evaluate(feature, String.class);
        Object value = localLookup.getValue(varName);
        if (value == null) {
            value = globalLookup.get(varName);
        }
        if (value == null && (paramSize = this.getParameters().size()) > this.getArgCount()) {
            value = this.getExpression(paramSize - 1).evaluate(feature);
        }
        return value;
    }

    @Override
    public void setParameters(List params) {
        if (params == null) {
            throw new NullPointerException("params can't be null");
        }
        int argCount = this.getArgCount();
        int paramsSize = params.size();
        if (paramsSize < argCount || paramsSize > argCount + 1) {
            throw new IllegalArgumentException(String.format("Function %s expected %d or %d arguments but got %d", this.name, argCount, argCount + 1, paramsSize));
        }
        this.params = new ArrayList(params);
    }

    @Override
    public void setFallbackValue(Literal fallback) {
        Logger logger = Logger.getLogger(EnvFunction.class.getName());
        logger.log(Level.WARNING, "The setFallbackValue is not supported by this function.Use a second argument when calling the function to provide a default value.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalLookup
    extends ThreadLocal<Map<String, Object>> {
        private LocalLookup() {
        }

        @Override
        protected Map<String, Object> initialValue() {
            return new LinkedHashMap<String, Object>();
        }

        public Object getValue(String name) {
            return ((Map)super.get()).get(name);
        }

        public Map<String, Object> getTable() {
            return (Map)super.get();
        }
    }
}

