/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Iterator;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCollectionIteration {
    protected final Handler handler;
    private final FeatureCollection<SimpleFeatureType, SimpleFeature> collection;

    public FeatureCollectionIteration(Handler handler, FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws NullPointerException {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (collection == null) {
            throw new NullPointerException("collection");
        }
        this.handler = handler;
        this.collection = collection;
    }

    public static void iteration(Handler handler, FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        FeatureCollectionIteration iteration = new FeatureCollectionIteration(handler, collection);
        iteration.iterate();
    }

    public void iterate() {
        this.walker(this.collection);
    }

    protected void walker(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this.handler.handleFeatureCollection(collection);
        this.iterate(collection.iterator());
        this.handler.endFeatureCollection(collection);
    }

    protected void iterate(Iterator iterator) {
        while (iterator.hasNext()) {
            this.walker((SimpleFeature)iterator.next());
        }
    }

    protected void walker(SimpleFeature feature) {
        SimpleFeatureType schema = feature.getFeatureType();
        int cnt = schema.getAttributeCount();
        this.handler.handleFeature(feature);
        for (int i = 0; i < cnt; ++i) {
            AttributeDescriptor type = schema.getDescriptor(i);
            if (FeatureCollection.class.isAssignableFrom(type.getType().getBinding())) {
                this.walker((FeatureCollection)feature.getAttribute(i));
                continue;
            }
            if (SimpleFeature.class.isAssignableFrom(type.getType().getBinding())) {
                this.walker((SimpleFeature)feature.getAttribute(i));
                continue;
            }
            this.handler.handleAttribute(type, feature.getAttribute(i));
        }
        this.handler.endFeature(feature);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handler {
        public void handleFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> var1);

        public void endFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> var1);

        public void handleFeature(SimpleFeature var1);

        public void endFeature(SimpleFeature var1);

        public void handleAttribute(AttributeDescriptor var1, Object var2);
    }
}

