/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wfs.GMLInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface WFSInfo
extends ServiceInfo {
    public Map<Version, GMLInfo> getGML();

    public int getMaxFeatures();

    public void setMaxFeatures(int var1);

    public ServiceLevel getServiceLevel();

    public void setServiceLevel(ServiceLevel var1);

    public boolean isFeatureBounding();

    public void setFeatureBounding(boolean var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServiceLevel {
        BASIC{

            @Override
            public int getCode() {
                return 1;
            }

            @Override
            public List<Operation> getOps() {
                return Arrays.asList(Operation.GETCAPABILITIES, Operation.DESCRIBEFEATURETYPE, Operation.GETFEATURE);
            }
        }
        ,
        TRANSACTIONAL{

            @Override
            public int getCode() {
                return 15;
            }

            @Override
            public List<Operation> getOps() {
                return Arrays.asList(Operation.GETCAPABILITIES, Operation.DESCRIBEFEATURETYPE, Operation.GETFEATURE, Operation.TRANSACTION_INSERT, Operation.TRANSACTION_UPDATE, Operation.TRANSACTION_DELETE);
            }
        }
        ,
        COMPLETE{

            @Override
            public int getCode() {
                return 31;
            }

            @Override
            public List<Operation> getOps() {
                return Arrays.asList(Operation.GETCAPABILITIES, Operation.DESCRIBEFEATURETYPE, Operation.GETFEATURE, Operation.TRANSACTION_INSERT, Operation.TRANSACTION_UPDATE, Operation.TRANSACTION_DELETE, Operation.LOCKFEATURE);
            }
        };


        public abstract int getCode();

        public abstract List<Operation> getOps();

        boolean contains(ServiceLevel other) {
            return this.getOps().containsAll(other.getOps());
        }

        public static ServiceLevel get(int code) {
            for (ServiceLevel s : ServiceLevel.values()) {
                if (s.getCode() != code) continue;
                return s;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        GETCAPABILITIES{

            public int getCode() {
                return 0;
            }
        }
        ,
        DESCRIBEFEATURETYPE{

            public int getCode() {
                return 0;
            }
        }
        ,
        GETFEATURE{

            public int getCode() {
                return 1;
            }
        }
        ,
        LOCKFEATURE{

            public int getCode() {
                return 2;
            }
        }
        ,
        TRANSACTION_INSERT{

            public int getCode() {
                return 4;
            }
        }
        ,
        TRANSACTION_UPDATE{

            public int getCode() {
                return 8;
            }
        }
        ,
        TRANSACTION_DELETE{

            public int getCode() {
                return 16;
            }
        };


        public abstract int getCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Version {
        V_10,
        V_11;


        static Version get(String v) {
            if (v.startsWith("1.0")) {
                return V_10;
            }
            if (v.startsWith("1.1")) {
                return V_11;
            }
            return null;
        }
    }
}

