/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.resources.Utilities;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.OtherText;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer2;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSymbolizerImpl
implements TextSymbolizer2,
Cloneable {
    private final FilterFactory filterFactory;
    private Fill fill;
    private List<Font> fonts = new ArrayList<Font>();
    private Halo halo;
    private LabelPlacement placement;
    private String geometryPropertyName = null;
    private Expression label = null;
    private Graphic graphic = null;
    private Expression priority = null;
    private HashMap<String, String> optionsMap = null;
    private Expression abxtract = null;
    private Expression description = null;
    private OtherText otherText = null;

    protected TextSymbolizerImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    protected TextSymbolizerImpl(FilterFactory factory) {
        this.filterFactory = factory;
        this.fill = new FillImpl();
        this.fill.setColor((Expression)this.filterFactory.literal((Object)"#000000"));
        this.halo = null;
        this.placement = new PointPlacementImpl();
    }

    public String geometryPropertyName() {
        return this.geometryPropertyName;
    }

    @Override
    public Fill getFill() {
        return this.fill;
    }

    @Override
    public void setFill(Fill fill) {
        if (this.fill == fill) {
            return;
        }
        this.fill = fill;
    }

    @Override
    public Font[] getFonts() {
        if (this.fonts.isEmpty()) {
            this.fonts.add(FontImpl.createDefault(this.filterFactory));
        }
        return this.fonts.toArray(new Font[this.fonts.size()]);
    }

    @Override
    public Font getFont() {
        if (this.fonts.isEmpty()) {
            return null;
        }
        return this.fonts.get(0);
    }

    public void addFont(Font font) {
        this.fonts.add(font);
    }

    @Override
    public void setFonts(Font[] fonts) {
        List<Font> newFonts = Arrays.asList(fonts);
        this.fonts.clear();
        this.fonts.addAll(newFonts);
    }

    @Override
    public Halo getHalo() {
        return this.halo;
    }

    @Override
    public void setHalo(Halo halo) {
        if (this.halo == halo) {
            return;
        }
        this.halo = halo;
    }

    @Override
    public Expression getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(Expression label) {
        this.label = label;
    }

    @Override
    public LabelPlacement getPlacement() {
        return this.placement;
    }

    @Override
    public void setPlacement(LabelPlacement labelPlacement) {
        if (this.placement == labelPlacement) {
            return;
        }
        this.placement = labelPlacement;
    }

    @Override
    public LabelPlacement getLabelPlacement() {
        return this.getPlacement();
    }

    @Override
    public void setLabelPlacement(LabelPlacement labelPlacement) {
        this.setPlacement(labelPlacement);
    }

    @Override
    public String getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    @Override
    public void setGeometryPropertyName(String geometryPropertyName) {
        this.geometryPropertyName = geometryPropertyName;
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.fonts != null) {
            result = 1000003 * result + ((Object)this.fonts).hashCode();
        }
        if (this.halo != null) {
            result = 1000003 * result + this.halo.hashCode();
        }
        if (this.placement != null) {
            result = 1000003 * result + this.placement.hashCode();
        }
        if (this.geometryPropertyName != null) {
            result = 1000003 * result + this.geometryPropertyName.hashCode();
        }
        if (this.label != null) {
            result = 1000003 * result + this.label.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof TextSymbolizerImpl) {
            TextSymbolizerImpl other = (TextSymbolizerImpl)oth;
            return Utilities.equals((Object)this.geometryPropertyName, (Object)other.geometryPropertyName) && Utilities.equals((Object)this.label, (Object)other.label) && Utilities.equals((Object)this.halo, (Object)other.halo) && Utilities.equals(this.fonts, other.fonts) && Utilities.equals((Object)this.placement, (Object)other.placement) && Utilities.equals((Object)this.fill, (Object)other.fill);
        }
        return false;
    }

    @Override
    public void setPriority(Expression priority) {
        if (this.priority == priority) {
            return;
        }
        this.priority = priority;
    }

    @Override
    public Expression getPriority() {
        return this.priority;
    }

    @Override
    public void addToOptions(String key, String value) {
        if (this.optionsMap == null) {
            this.optionsMap = new HashMap();
        }
        this.optionsMap.put(key, value.trim());
    }

    @Override
    public String getOption(String key) {
        if (this.optionsMap == null) {
            return null;
        }
        return this.optionsMap.get(key);
    }

    @Override
    public Map<String, String> getOptions() {
        return this.optionsMap;
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    @Override
    public void setGraphic(Graphic graphic) {
        if (this.graphic == graphic) {
            return;
        }
        this.graphic = graphic;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<TextSymbolizerImp property=");
        buf.append(this.geometryPropertyName);
        buf.append(" label=");
        buf.append(this.label);
        buf.append(">");
        buf.append(this.fonts);
        return buf.toString();
    }

    @Override
    public Expression getSnippet() {
        return this.abxtract;
    }

    @Override
    public void setSnippet(Expression abxtract) {
        this.abxtract = abxtract;
    }

    @Override
    public Expression getFeatureDescription() {
        return this.description;
    }

    @Override
    public void setFeatureDescription(Expression description) {
        this.description = description;
    }

    @Override
    public OtherText getOtherText() {
        return this.otherText;
    }

    @Override
    public void setOtherText(OtherText otherText) {
        this.otherText = otherText;
    }
}

