/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.Fill;
import org.geotools.styling.Mark;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleFactoryImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

public class MarkImpl
implements Mark,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.styling");
    private final FilterFactory filterFactory;
    private Fill fill;
    private Stroke stroke;
    private Expression wellKnownName = null;
    private Expression rotation = null;
    private Expression size = null;

    public MarkImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public MarkImpl(String name) {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
        LOGGER.fine("creating " + name + " type mark");
        this.setWellKnownName(name);
    }

    public MarkImpl(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
        LOGGER.fine("creating defaultMark");
        try {
            StyleFactoryImpl sfac = new StyleFactoryImpl();
            this.fill = sfac.getDefaultFill();
            this.stroke = sfac.getDefaultStroke();
            this.wellKnownName = filterFactory.literal((Object)"square");
            this.size = filterFactory.literal((Object)new Integer(6));
            this.rotation = filterFactory.literal((Object)new Double(0.0));
        }
        catch (IllegalFilterException ife) {
            MarkImpl.severe("<init>", "Failed to build default mark: ", ife);
        }
    }

    private static void severe(String method, String message, Exception exception) {
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setSourceMethodName(method);
        record.setThrown(exception);
        LOGGER.log(record);
    }

    public Fill getFill() {
        return this.fill;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Expression getWellKnownName() {
        return this.wellKnownName;
    }

    public void setFill(Fill fill) {
        this.fill = fill;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setSize(Expression size) {
        this.size = size;
    }

    public void setSize(int size) {
        this.setSize((Expression)this.filterFactory.literal(size));
    }

    public void setWellKnownName(Expression wellKnownName) {
        LOGGER.entering("DefaultMark", "setWellKnownName");
        this.wellKnownName = wellKnownName;
    }

    public void setWellKnownName(String name) {
        this.setWellKnownName((Expression)this.filterFactory.literal((Object)name));
    }

    public void setRotation(Expression rotation) {
        this.rotation = rotation;
    }

    public void setRotation(double rotation) {
        this.setRotation((Expression)this.filterFactory.literal(rotation));
    }

    public Expression getSize() {
        return this.size;
    }

    public Expression getRotation() {
        return this.rotation;
    }

    public String toString() {
        return this.wellKnownName.toString();
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            MarkImpl clone = (MarkImpl)super.clone();
            if (this.fill != null) {
                clone.fill = (Fill)((Cloneable)this.fill).clone();
            }
            if (this.stroke != null && this.stroke instanceof Cloneable) {
                clone.stroke = (Stroke)((Cloneable)this.stroke).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone MarkImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.stroke != null) {
            result = 1000003 * result + this.stroke.hashCode();
        }
        if (this.wellKnownName != null) {
            result = 1000003 * result + this.wellKnownName.hashCode();
        }
        if (this.rotation != null) {
            result = 1000003 * result + this.rotation.hashCode();
        }
        if (this.size != null) {
            result = 1000003 * result + this.size.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        MarkImpl other = (MarkImpl)oth;
        if (this.wellKnownName == null ? other.wellKnownName != null : !this.wellKnownName.equals(other.wellKnownName)) {
            return false;
        }
        if (this.rotation == null ? other.rotation != null : !this.rotation.equals(other.rotation)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        return !(this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke));
    }
}

