/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExtractBoundsFilterVisitor
extends NullFilterVisitor {
    public static NullFilterVisitor BOUNDS_VISITOR = new ExtractBoundsFilterVisitor();
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.index.rtree");

    protected ExtractBoundsFilterVisitor() {
    }

    private ReferencedEnvelope bbox(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)data;
        }
        if (data instanceof Envelope) {
            return new ReferencedEnvelope((Envelope)data, null);
        }
        if (data instanceof CoordinateReferenceSystem) {
            return new ReferencedEnvelope((CoordinateReferenceSystem)data);
        }
        throw new ClassCastException("Could not cast data to ReferencedEnvelope");
    }

    public Object visit(ExcludeFilter filter, Object data) {
        return null;
    }

    public Object visit(IncludeFilter filter, Object data) {
        if (data == null) {
            return null;
        }
        ReferencedEnvelope bbox = this.bbox(data);
        Envelope world = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        bbox.expandToInclude(world);
        return bbox;
    }

    public Object visit(BBOX filter, Object data) {
        if (data == null) {
            return null;
        }
        ReferencedEnvelope bbox = this.bbox(data);
        Envelope bounds = new Envelope(filter.getMinX(), filter.getMaxX(), filter.getMinY(), filter.getMaxY());
        bbox.expandToInclude(bounds);
        return bbox;
    }

    public Object visit(Literal expression, Object data) {
        if (data == null) {
            return null;
        }
        ReferencedEnvelope bbox = this.bbox(data);
        Object value = expression.getValue();
        if (value instanceof Geometry) {
            Geometry geometry = (Geometry)value;
            Envelope bounds = geometry.getEnvelopeInternal();
            bbox.expandToInclude(bounds);
        } else {
            LOGGER.finer("LiteralExpression ignored!");
        }
        return bbox;
    }

    public Object visit(Beyond filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(Contains filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(Crosses filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(Disjoint filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(DWithin filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(Equals filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(Intersects filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(Overlaps filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(Touches filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    public Object visit(Within filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }
}

