/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import org.geotools.filter.Filters;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.resources.Utilities;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Multiply;

public class MultiplyImpl
extends MathExpressionImpl
implements Multiply {
    public MultiplyImpl(Expression expr1, Expression expr2) {
        super(expr1, expr2);
        this.expressionType = (short)107;
    }

    public Object evaluate(Object feature) throws IllegalArgumentException {
        this.ensureOperandsSet();
        double leftDouble = Filters.number(this.getExpression1().evaluate(feature));
        double rightDouble = Filters.number(this.getExpression2().evaluate(feature));
        return this.number(leftDouble * rightDouble);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Multiply)this, extraData);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiplyImpl) {
            MultiplyImpl other = (MultiplyImpl)obj;
            return Utilities.equals((Object)this.getExpression1(), (Object)other.getExpression1()) && Utilities.equals((Object)this.getExpression2(), (Object)other.getExpression2());
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result = 37 * result + this.getExpression1().hashCode();
        result = 37 * result + this.getExpression2().hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.getExpression1().toString() + "*" + this.getExpression2().toString() + ")";
    }
}

