/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessors;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;

public class AttributeExpressionImpl
extends DefaultExpression
implements AttributeExpression {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.core");
    protected String attPath;
    protected SimpleFeatureType schema = null;
    private Hints hints;
    private PropertyAccessor lastAccessor;

    protected AttributeExpressionImpl(SimpleFeatureType schema) {
        this.schema = schema;
        this.expressionType = (short)113;
    }

    public AttributeExpressionImpl(String xpath) {
        this(xpath, null);
    }

    public AttributeExpressionImpl(String xpath, Hints propertyAccessorHints) {
        this.attPath = xpath;
        this.schema = null;
        this.hints = propertyAccessorHints;
        this.expressionType = (short)113;
    }

    protected AttributeExpressionImpl(SimpleFeatureType schema, String attPath) throws IllegalFilterException {
        this.schema = schema;
        this.expressionType = (short)113;
        this.setAttributePath(attPath);
    }

    public final void setAttributePath(String attPath) throws IllegalFilterException {
        this.setPropertyName(attPath);
    }

    public final String getAttributePath() {
        return this.getPropertyName();
    }

    public String getPropertyName() {
        return this.attPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyName(String attPath) {
        LOGGER.entering("ExpressionAttribute", "setAttributePath", attPath);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("schema: " + this.schema + "\n\nattribute: " + attPath);
        }
        if (this.schema != null) {
            if (this.schema.getDescriptor(attPath) == null) throw new IllegalFilterException("Attribute: " + attPath + " is not in stated schema " + this.schema.getTypeName() + ".");
            this.attPath = attPath;
            return;
        } else {
            this.attPath = attPath;
        }
    }

    public Object evaluate(SimpleFeature feature) {
        PropertyAccessor accessor = this.getPropertyAccessor(feature, null);
        if (accessor == null) {
            return null;
        }
        return accessor.get(feature, this.attPath, null);
    }

    public Object evaluate(Object obj) {
        return this.evaluate(obj, null);
    }

    public Object evaluate(Object obj, Class target) {
        PropertyAccessor accessor = this.getPropertyAccessor(obj, target);
        if (accessor == null) {
            return null;
        }
        Object value = accessor.get(obj, this.attPath, target);
        if (target == null) {
            return value;
        }
        return Converters.convert(value, target);
    }

    private synchronized PropertyAccessor getPropertyAccessor(Object obj, Class target) {
        if (this.lastAccessor == null) {
            this.lastAccessor = PropertyAccessors.findPropertyAccessor(obj, this.attPath, target, this.hints);
        } else if (!this.lastAccessor.canHandle(obj, this.attPath, target)) {
            this.lastAccessor = PropertyAccessors.findPropertyAccessor(obj, this.attPath, target, this.hints);
        }
        return this.lastAccessor;
    }

    public String toString() {
        return this.attPath;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == this.getClass()) {
            boolean isEqual;
            AttributeExpressionImpl expAttr = (AttributeExpressionImpl)obj;
            boolean bl = isEqual = expAttr.getType() == this.expressionType;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("expression type match:" + isEqual + "; in:" + expAttr.getType() + "; out:" + this.expressionType);
            }
            boolean bl2 = expAttr.attPath != null ? isEqual && expAttr.attPath.equals(this.attPath) : (isEqual = isEqual && this.attPath == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("attribute match:" + isEqual + "; in:" + expAttr.getAttributePath() + "; out:" + this.attPath);
            }
            boolean bl3 = expAttr.schema != null ? isEqual && expAttr.schema.equals(this.schema) : (isEqual = isEqual && this.schema == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("schema match:" + isEqual + "; in:" + expAttr.schema + "; out:" + this.schema);
            }
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attPath == null ? 0 : this.attPath.hashCode());
        result = 37 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((PropertyName)this, extraData);
    }
}

