/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataStore;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.TypeDiffState;
import org.geotools.data.store.TypeEntry;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActiveTypeEntry
implements TypeEntry {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.store");
    protected DataStore parent;
    private final SimpleFeatureType schema;
    private final Map metadata;
    private FeatureListenerManager listeners = new FeatureListenerManager();
    int count;
    Envelope bounds;
    public FeatureListenerManager listenerManager = new FeatureListenerManager();

    public ActiveTypeEntry(DataStore parent, SimpleFeatureType schema, Map metadata) {
        this.schema = schema;
        this.metadata = metadata;
        this.parent = parent;
    }

    @Override
    public InternationalString getDisplayName() {
        return new SimpleInternationalString(this.schema.getTypeName());
    }

    @Override
    public InternationalString getDescription() {
        return null;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public String[] getMetadataNames() {
        return this.metadata.keySet().toArray(new String[this.metadata.size()]);
    }

    public Map metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String getTypeName() {
        return this.schema.getTypeName();
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader(Query query, Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("Transaction null, did you mean Transaction.AUTO_COMMIT");
        }
        FeatureCollection<SimpleFeatureType, SimpleFeature> features = this.createFeatureSource().getFeatures(query);
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(features.getSchema(), features.features());
        if (!transaction.equals(Transaction.AUTO_COMMIT)) {
            reader = new DiffFeatureReader<SimpleFeatureType, SimpleFeature>(reader, this.state(transaction).diff());
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeDiffState state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TypeDiffState state = (TypeDiffState)transaction.getState(this);
            if (state == null) {
                state = new TypeDiffState(this);
                transaction.putState(this, state);
            }
            return state;
        }
    }

    @Override
    public void fireAdded(SimpleFeature newFeature, Transaction transaction) {
        ReferencedEnvelope bounds = ReferencedEnvelope.reference(newFeature != null ? newFeature.getBounds() : null);
        this.listenerManager.fireFeaturesAdded(this.schema.getTypeName(), transaction, bounds, false);
    }

    @Override
    public void fireRemoved(SimpleFeature removedFeature, Transaction transaction) {
        ReferencedEnvelope bounds = ReferencedEnvelope.reference(removedFeature != null ? removedFeature.getBounds() : null);
        this.listenerManager.fireFeaturesRemoved(this.schema.getTypeName(), transaction, bounds, false);
    }

    @Override
    public void fireChanged(SimpleFeature before, SimpleFeature after, Transaction transaction) {
        String typeName = after.getFeatureType().getTypeName();
        ReferencedEnvelope bounds = new ReferencedEnvelope();
        bounds.include(before.getBounds());
        bounds.include(after.getBounds());
        this.listenerManager.fireFeaturesChanged(typeName, transaction, bounds, false);
    }

    @Override
    public abstract FeatureSource<SimpleFeatureType, SimpleFeature> createFeatureSource();

    protected FeatureSource<SimpleFeatureType, SimpleFeature> createFeatureSource(final SimpleFeatureType featureType) {
        return new AbstractFeatureSource(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public SimpleFeatureType getSchema() {
                return featureType;
            }
        };
    }

    protected FeatureStore<SimpleFeatureType, SimpleFeature> createFeatureStore() {
        return new AbstractFeatureStore(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public SimpleFeatureType getSchema() {
                return ActiveTypeEntry.this.schema;
            }
        };
    }

    protected FeatureLocking<SimpleFeatureType, SimpleFeature> createFeatureLocking() {
        return new AbstractFeatureLocking(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public SimpleFeatureType getSchema() {
                return ActiveTypeEntry.this.schema;
            }
        };
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> createReader() {
        return new EmptyFeatureReader<SimpleFeatureType, SimpleFeature>(this.schema);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> createReader(Query query) throws IOException {
        return this.createReader();
    }

    protected Filter getUnsupportedFilter(Filter filter) {
        return filter;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> writer(Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = transaction == Transaction.AUTO_COMMIT ? this.createWriter() : this.state(transaction).writer();
        if (this.parent.getLockingManager() != null && this.parent.getLockingManager() instanceof InProcessLockingManager) {
            InProcessLockingManager lockingManger = (InProcessLockingManager)this.parent.getLockingManager();
            writer = lockingManger.checkedWriter(writer, transaction);
        }
        return writer;
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createWriter() {
        return new EmptyFeatureWriter(this.schema);
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createAppend(Transaction transaction) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer(transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }
}

