/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import com.sun.media.imageioimpl.common.ImageUtil;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;

public final class GDALUtilities {
    public static final String STANDARD_METADATA_NAME = "javax_imageio_1.0";
    public static final String newLine = System.getProperty("line.separator");
    public static final String GDALMEMORYRASTER_MAXSIZE_KEY = "it.geosolutions.gdalmemoryrastermaxsize";
    private static final String CPL_DEBUG = "CPL_DEBUG";
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.gdalframework");
    private static boolean available;
    private static boolean init;
    private static boolean isJAIavailable;
    private static final Map driversWritingCapabilities;
    public static final Dimension DEFAULT_TILE_SIZE;
    public static final int MIN_TILE_SIZE = 256;
    static final String NEWLINE;

    private GDALUtilities() {
    }

    private static boolean getAsBoolean(String value) {
        return value != null && value.trim().length() > 0 && (value.equalsIgnoreCase("ON") || value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("YES"));
    }

    public static int retrieveGDALDataBufferType(int dataBufferType) {
        switch (dataBufferType) {
            case 0: {
                return gdalconstConstants.GDT_Byte;
            }
            case 1: {
                return gdalconstConstants.GDT_UInt16;
            }
            case 2: {
                return gdalconstConstants.GDT_Int16;
            }
            case 3: {
                return gdalconstConstants.GDT_Int32;
            }
            case 4: {
                return gdalconstConstants.GDT_Float32;
            }
            case 5: {
                return gdalconstConstants.GDT_Float64;
            }
        }
        return gdalconstConstants.GDT_Unknown;
    }

    public static int getCacheMax() {
        return gdal.GetCacheMax();
    }

    public static int getCacheUsed() {
        return gdal.GetCacheUsed();
    }

    public static List getJDKImageReaderWriterSPI(ServiceRegistry registry, String formatName, boolean isReader) {
        IIORegistry iioRegistry = (IIORegistry)registry;
        Class spiClass = isReader ? ImageReaderSpi.class : ImageWriterSpi.class;
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            String[] formatNames = provider.getFormatNames();
            int length = formatNames.length;
            for (int i = 0; i < length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static void setCacheMax(int maxCacheSize) {
        gdal.SetCacheMax((int)maxCacheSize);
    }

    public static void setGdalCaching(boolean useCaching) {
        String sOption = useCaching ? "YES" : "NO";
        gdal.SetConfigOption((String)"GDAL_FORCE_CACHING", (String)sOption);
    }

    public static void setGdalPAM(boolean usePAM) {
        String sOption = usePAM ? "YES" : "NO";
        gdal.SetConfigOption((String)"GDAL_PAM_ENABLED", (String)sOption);
    }

    public static synchronized Dataset acquireDataSet(String name, int accessType) {
        if (!GDALUtilities.isGDALAvailable()) {
            return null;
        }
        return gdal.Open((String)name, (int)accessType);
    }

    public static List getGDALImageMetadata(String dataSetName) {
        Vector gdalImageMetadata;
        Dataset ds = GDALUtilities.acquireDataSet(dataSetName, gdalconst.GA_ReadOnly);
        if (ds != null) {
            gdalImageMetadata = ds.GetMetadata_List("");
            GDALUtilities.closeDataSet(ds);
        } else {
            gdalImageMetadata = null;
        }
        return gdalImageMetadata;
    }

    public static synchronized void closeDataSet(Dataset ds) {
        if (!GDALUtilities.isGDALAvailable()) {
            return;
        }
        if (ds == null) {
            throw new NullPointerException("The provided dataset is null");
        }
        ds.delete();
    }

    public static boolean isDriverAvailable(String driverName) {
        if (!GDALUtilities.isGDALAvailable()) {
            return false;
        }
        Driver driver = gdal.GetDriverByName((String)driverName);
        return driver != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int formatWritingCapabilities(String driverName) {
        if (driverName == null) {
            throw new IllegalArgumentException("The provided driver name is null");
        }
        GDALUtilities.loadGDAL();
        Map map = driversWritingCapabilities;
        synchronized (map) {
            int retVal;
            boolean createCopySupported;
            if (driversWritingCapabilities.containsKey(driverName)) {
                return (Integer)driversWritingCapabilities.get(driverName);
            }
            Driver driver = gdal.GetDriverByName((String)driverName);
            if (driver == null) {
                throw new IllegalArgumentException("A Driver with the specified name is unavailable. Check the specified name or be sure this Driver is supported");
            }
            Hashtable metadata = driver.GetMetadata_Dict("");
            String create = (String)metadata.get("DCAP_CREATE");
            String createCopy = (String)metadata.get("DCAP_CREATECOPY");
            boolean createSupported = create != null && create.equalsIgnoreCase("yes");
            boolean bl = createCopySupported = createCopy != null && createCopy.equalsIgnoreCase("yes");
            if (createSupported) {
                driversWritingCapabilities.put(driverName, new Integer(0));
                retVal = 0;
            } else if (createCopySupported) {
                driversWritingCapabilities.put(driverName, new Integer(1));
                retVal = 1;
            } else {
                driversWritingCapabilities.put(driverName, new Integer(2));
                retVal = 2;
            }
            return retVal;
        }
    }

    public static String getStreamMetadataItem(String metadataName, String datasetName) {
        return GDALUtilities.getMetadataItem(GDALUtilities.getGDALStreamMetadata(datasetName), metadataName);
    }

    public static String getMetadataItem(List imageMetadata, String metadataName) {
        for (String s : imageMetadata) {
            int indexOfEqualSymbol;
            String sName = s.substring(0, indexOfEqualSymbol = s.indexOf(61));
            if (!sName.equals(metadataName)) continue;
            return s.substring(indexOfEqualSymbol + 1, s.length());
        }
        return null;
    }

    public static List getGDALStreamMetadata(String datasetName) {
        Dataset ds = GDALUtilities.acquireDataSet(datasetName, gdalconst.GA_ReadOnly);
        Vector gdalStreamMetadata = ds.GetMetadata_List("SUBDATASETS");
        GDALUtilities.closeDataSet(ds);
        return gdalStreamMetadata;
    }

    public static void setNodeAttribute(String name, Object val, IIOMetadataNode node, int attributeType) {
        try {
            String value;
            if (val != null && val instanceof String && (value = (String)val) != null && value.length() > 0) {
                switch (attributeType) {
                    case 4: {
                        Double.parseDouble(value);
                        break;
                    }
                    case 3: {
                        Float.parseFloat(value);
                        break;
                    }
                    case 2: {
                        Integer.parseInt(value);
                        break;
                    }
                    case 1: {
                        Boolean.valueOf(value);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                node.setAttribute(name, value);
                return;
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.fine("The specified value has not been successfully parsed: " + (String)val);
        }
        node.setAttribute(name, "");
    }

    public static Dimension toTileSize(Dimension size) {
        Dimension defaultSize = JAI.getDefaultTileSize();
        if (defaultSize == null) {
            defaultSize = DEFAULT_TILE_SIZE;
        }
        size.height = defaultSize.height;
        size.width = defaultSize.width;
        return size;
    }

    public static boolean isGDALAvailable() {
        GDALUtilities.loadGDAL();
        return available;
    }

    public static synchronized void loadGDAL() {
        if (init) {
            return;
        }
        init = true;
        try {
            System.loadLibrary("gdaljni");
            gdal.AllRegister();
            String cplDebug = System.getProperty(CPL_DEBUG);
            boolean showErrors = GDALUtilities.getAsBoolean(cplDebug);
            if (!showErrors) {
                gdal.PushErrorHandler((String)"CPLQuietErrorHandler");
            }
            available = true;
        }
        catch (UnsatisfiedLinkError e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(new StringBuffer("Native library load failed.").append(e.toString()).toString());
            }
            available = false;
        }
    }

    public static ColorModel buildColorModel(SampleModel sampleModel) {
        ColorSpace cs = null;
        ColorModel colorModel = null;
        int buffer_type = sampleModel.getDataType();
        int numBands = sampleModel.getNumBands();
        if (numBands > 1) {
            colorModel = ImageUtil.createColorModel((SampleModel)sampleModel);
            if (colorModel == null) {
                LOGGER.severe("No ColorModels found");
            }
        } else if (buffer_type == 0 || buffer_type == 1 || buffer_type == 3 || buffer_type == 4 || buffer_type == 5) {
            cs = ColorSpace.getInstance(1003);
            colorModel = RasterFactory.createComponentColorModel((int)buffer_type, (ColorSpace)cs, (boolean)false, (boolean)false, (int)1);
        } else if (buffer_type == 2) {
            cs = ColorSpace.getInstance(1003);
            colorModel = new ComponentColorModel(cs, false, false, 1, 2);
        }
        return colorModel;
    }

    static {
        init = false;
        GDALUtilities.loadGDAL();
        try {
            Class.forName("javax.media.jai.JAI");
            isJAIavailable = true;
        }
        catch (ClassNotFoundException cnf) {
            isJAIavailable = false;
        }
        driversWritingCapabilities = Collections.synchronizedMap(new HashMap());
        DEFAULT_TILE_SIZE = new Dimension(512, 512);
        NEWLINE = System.getProperty("line.separator");
    }

    public static final class DriverCreateCapabilities {
        public static final int CREATE = 0;
        public static final int CREATE_COPY = 1;
        public static final int READ_ONLY = 2;
    }

    public static final class GDALMetadataDomain {
        public static final String IMAGESTRUCTURE = "IMAGE_STRUCTURE";
        public static final String SUBDATASETS = "SUBDATASETS";
        public static final String DEFAULT = "";
        protected static final String DEFAULT_KEY_MAP = "DEF";
        public static final String XML_PREFIX = "xml:";
    }
}

