/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALCommonIIOStreamMetadata;
import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.DataBufferDouble;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;

public abstract class GDALImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.gdalframework");
    private String[] datasetNames;
    private int nSubdatasets = -1;
    private ImageInputStream imageInputStream;
    private volatile boolean isInitialized = false;
    private ImageTypeSpecifier imageType = null;
    private File datasetSource = null;
    private URI uriSource = null;
    private Map datasetMap = Collections.synchronizedMap(new HashMap(10));

    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input, seekForwardOnly, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDALCommonIIOImageMetadata getDatasetMetadata(int imageIndex) {
        this.checkImageIndex(imageIndex);
        String datasetName = this.datasetNames[imageIndex];
        Map map = this.datasetMap;
        synchronized (map) {
            if (this.datasetMap.containsKey(datasetName)) {
                return (GDALCommonIIOImageMetadata)((Object)this.datasetMap.get(datasetName));
            }
            GDALCommonIIOImageMetadata datasetMetadata = this.createDatasetMetadata(datasetName);
            this.datasetMap.put(datasetName, datasetMetadata);
            return datasetMetadata;
        }
    }

    public GDALImageReader(GDALImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public GDALImageReader(GDALImageReaderSpi originatingProvider, int numSubdatasets) {
        super(originatingProvider);
        if (numSubdatasets < 0) {
            throw new IllegalArgumentException("The provided number of sub datasets is invalid");
        }
        this.nSubdatasets = numSubdatasets;
    }

    protected void checkImageIndex(int imageIndex) {
        this.initialize();
        if (imageIndex < 0 || imageIndex > this.nSubdatasets) {
            int maxImageIndex = this.nSubdatasets;
            StringBuffer sb = new StringBuffer("Illegal imageIndex specified = ").append(imageIndex).append(", while the valid imageIndex");
            if (maxImageIndex > 0) {
                sb.append(" range should be (0,").append(maxImageIndex).append(")!!");
            } else {
                sb.append(" should be 0!");
            }
            throw new IndexOutOfBoundsException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize() {
        if (!GDALUtilities.isGDALAvailable()) {
            throw new IllegalStateException("GDAL native libraries are not available.");
        }
        Map map = this.datasetMap;
        synchronized (map) {
            if (!this.isInitialized) {
                String mainDatasetName = "";
                Object datainput = super.getInput();
                if (!(datainput instanceof URIImageInputStream)) {
                    mainDatasetName = this.getDatasetSource(datainput).getAbsolutePath();
                } else {
                    URI uri = ((URIImageInputStream)datainput).getUri();
                    if (uri != null) {
                        mainDatasetName = uri.toString();
                    }
                }
                Dataset mainDataset = GDALUtilities.acquireDataSet(mainDatasetName, gdalconstConstants.GA_ReadOnly);
                if (mainDataset == null) {
                    return false;
                }
                Vector subdatasets = mainDataset.GetMetadata_List("SUBDATASETS");
                this.nSubdatasets = subdatasets.size() / 2;
                if (this.nSubdatasets == 0) {
                    this.nSubdatasets = 1;
                    this.datasetNames = new String[1];
                    this.datasetNames[0] = mainDatasetName;
                    GDALCommonIIOImageMetadata myItem = this.createDatasetMetadata(this.datasetNames[0]);
                    this.datasetMap.put(this.datasetNames[0], myItem);
                } else {
                    this.datasetNames = new String[this.nSubdatasets + 1];
                    for (int i = 0; i < this.nSubdatasets; ++i) {
                        String subdatasetName = subdatasets.get(i * 2).toString();
                        int nameStartAt = subdatasetName.lastIndexOf("_NAME=") + 6;
                        this.datasetNames[i] = subdatasetName.substring(nameStartAt);
                    }
                    this.datasetNames[this.nSubdatasets] = mainDatasetName;
                    this.datasetMap.put(mainDatasetName, this.createDatasetMetadata(mainDataset, mainDatasetName));
                    subdatasets.clear();
                }
                this.isInitialized = true;
                GDALUtilities.closeDataSet(mainDataset);
            }
        }
        return this.nSubdatasets > 0;
    }

    protected GDALCommonIIOImageMetadata createDatasetMetadata(String datasetName) {
        return new GDALCommonIIOImageMetadata(datasetName);
    }

    protected GDALCommonIIOImageMetadata createDatasetMetadata(Dataset mainDataset, String mainDatasetFileName) {
        return new GDALCommonIIOImageMetadata(mainDataset, mainDatasetFileName, false);
    }

    private Raster readDatasetRaster(GDALCommonIIOImageMetadata item, Rectangle srcRegion, Rectangle dstRegion, int[] selectedBands) throws IOException {
        return this.readDatasetRaster(item, srcRegion, dstRegion, selectedBands, null);
    }

    private Raster readDatasetRaster(GDALCommonIIOImageMetadata item, Rectangle srcRegion, Rectangle dstRegion, int[] selectedBands, SampleModel destSampleModel) throws IOException {
        Buffer buff;
        SampleModel destSm = destSampleModel != null ? destSampleModel : item.getSampleModel();
        ComponentSampleModel sampleModel = null;
        DataBuffer imgBuffer = null;
        String datasetName = item.getDatasetName();
        Dataset dataset = GDALUtilities.acquireDataSet(datasetName, gdalconst.GA_ReadOnly);
        if (dataset == null) {
            throw new IOException("Error while acquiring the input dataset " + datasetName);
        }
        int dstWidth = dstRegion.width;
        int dstHeight = dstRegion.height;
        int srcRegionXOffset = srcRegion.x;
        int srcRegionYOffset = srcRegion.y;
        int srcRegionWidth = srcRegion.width;
        int srcRegionHeight = srcRegion.height;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SourceRegion = " + srcRegion.toString());
        }
        Band pBand = null;
        int nBands = selectedBands != null ? selectedBands.length : destSm.getNumBands();
        int[] banks = new int[nBands];
        int[] offsets = new int[nBands];
        int pixels = dstWidth * dstHeight;
        int bufferType = 0;
        int bufferSize = 0;
        pBand = dataset.GetRasterBand(1);
        bufferType = pBand.getDataType();
        int typeSizeInBytes = gdal.GetDataTypeSize((int)bufferType) / 8;
        bufferSize = nBands * pixels * typeSizeInBytes;
        boolean splitBands = false;
        if (bufferSize < 0 || destSm instanceof BandedSampleModel) {
            bufferSize = pixels * typeSizeInBytes;
            splitBands = true;
        }
        int dataBufferType = -1;
        ByteBuffer[] bands = new ByteBuffer[nBands];
        for (int k = 0; k < nBands && (k <= 0 || splitBands); ++k) {
            int returnVal;
            ByteBuffer dataBuffer = ByteBuffer.allocateDirect(bufferSize);
            if (!splitBands) {
                if (selectedBands != null) {
                    int[] bandsMap = new int[nBands];
                    for (int i = 0; i < nBands; ++i) {
                        bandsMap[i] = selectedBands[i] + 1;
                    }
                    returnVal = dataset.ReadRaster_Direct(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight, dstWidth, dstHeight, bufferType, nBands, bandsMap, nBands * typeSizeInBytes, dstWidth * nBands * typeSizeInBytes, typeSizeInBytes, dataBuffer);
                } else {
                    returnVal = dataset.ReadRaster_Direct(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight, dstWidth, dstHeight, bufferType, nBands, nBands * typeSizeInBytes, dstWidth * nBands * typeSizeInBytes, typeSizeInBytes, dataBuffer);
                }
                bands[k] = dataBuffer;
            } else {
                returnVal = dataset.GetRasterBand(k + 1).ReadRaster_Direct(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight, dstWidth, dstHeight, bufferType, dataBuffer);
                bands[k] = dataBuffer;
            }
            if (returnVal == gdalconstConstants.CE_None) {
                if (!splitBands) {
                    for (int band = 0; band < nBands; ++band) {
                        banks[band] = band;
                        offsets[band] = band;
                    }
                    continue;
                }
                banks[k] = k;
                offsets[k] = 0;
                continue;
            }
            LOGGER.info(new StringBuffer("Last error: ").append(gdal.GetLastErrorMsg()).toString());
            LOGGER.info(new StringBuffer("Last error number: ").append(gdal.GetLastErrorNo()).toString());
            LOGGER.info(new StringBuffer("Last error type: ").append(gdal.GetLastErrorType()).toString());
            GDALUtilities.closeDataSet(dataset);
            throw new RuntimeException(gdal.GetLastErrorMsg());
        }
        if (bufferType == gdalconstConstants.GDT_Byte) {
            if (!splitBands) {
                byte[] bytes = new byte[nBands * pixels];
                bands[0].get(bytes, 0, nBands * pixels);
                imgBuffer = new DataBufferByte(bytes, nBands * pixels);
            } else {
                byte[][] bytes = new byte[nBands][];
                for (int i = 0; i < nBands; ++i) {
                    bytes[i] = new byte[pixels];
                    bands[i].get(bytes[i], 0, pixels);
                }
                imgBuffer = new DataBufferByte(bytes, pixels);
            }
            dataBufferType = 0;
        } else if (bufferType == gdalconstConstants.GDT_Int16 || bufferType == gdalconstConstants.GDT_UInt16) {
            if (!splitBands) {
                short[] shorts = new short[nBands * pixels];
                bands[0].order(ByteOrder.nativeOrder());
                buff = bands[0].asShortBuffer();
                ((ShortBuffer)buff).get(shorts, 0, nBands * pixels);
                imgBuffer = bufferType == gdalconstConstants.GDT_Int16 ? new DataBufferShort(shorts, nBands * pixels) : new DataBufferUShort(shorts, nBands * pixels);
            } else {
                short[][] shorts = new short[nBands][];
                for (int i = 0; i < nBands; ++i) {
                    shorts[i] = new short[pixels];
                    bands[i].order(ByteOrder.nativeOrder());
                    bands[i].asShortBuffer().get(shorts[i], 0, pixels);
                }
                imgBuffer = bufferType == gdalconstConstants.GDT_Int16 ? new DataBufferShort(shorts, pixels) : new DataBufferUShort(shorts, pixels);
            }
            dataBufferType = bufferType == gdalconstConstants.GDT_UInt16 ? 1 : 2;
        } else if (bufferType == gdalconstConstants.GDT_Int32 || bufferType == gdalconstConstants.GDT_UInt32) {
            if (!splitBands) {
                int[] ints = new int[nBands * pixels];
                bands[0].order(ByteOrder.nativeOrder());
                buff = bands[0].asIntBuffer();
                ((IntBuffer)buff).get(ints, 0, nBands * pixels);
                imgBuffer = new DataBufferInt(ints, nBands * pixels);
            } else {
                int[][] ints = new int[nBands][];
                for (int i = 0; i < nBands; ++i) {
                    ints[i] = new int[pixels];
                    bands[i].order(ByteOrder.nativeOrder());
                    bands[i].asIntBuffer().get(ints[i], 0, pixels);
                }
                imgBuffer = new DataBufferInt(ints, pixels);
            }
            dataBufferType = 3;
        } else if (bufferType == gdalconstConstants.GDT_Float32) {
            if (!splitBands) {
                float[] floats = new float[nBands * pixels];
                bands[0].order(ByteOrder.nativeOrder());
                buff = bands[0].asFloatBuffer();
                ((FloatBuffer)buff).get(floats, 0, nBands * pixels);
                imgBuffer = new DataBufferFloat(floats, nBands * pixels);
            } else {
                float[][] floats = new float[nBands][];
                for (int i = 0; i < nBands; ++i) {
                    floats[i] = new float[pixels];
                    bands[i].order(ByteOrder.nativeOrder());
                    bands[i].asFloatBuffer().get(floats[i], 0, pixels);
                }
                imgBuffer = new DataBufferFloat(floats, pixels);
            }
            dataBufferType = 4;
        } else if (bufferType == gdalconstConstants.GDT_Float64) {
            if (!splitBands) {
                double[] doubles = new double[nBands * pixels];
                bands[0].order(ByteOrder.nativeOrder());
                buff = bands[0].asDoubleBuffer();
                ((DoubleBuffer)buff).get(doubles, 0, nBands * pixels);
                imgBuffer = new DataBufferDouble(doubles, nBands * pixels);
            } else {
                double[][] doubles = new double[nBands][];
                for (int i = 0; i < nBands; ++i) {
                    doubles[i] = new double[pixels];
                    bands[i].order(ByteOrder.nativeOrder());
                    bands[i].asDoubleBuffer().get(doubles[i], 0, pixels);
                }
                imgBuffer = new DataBufferDouble((double[][])doubles, pixels);
            }
            dataBufferType = 5;
        } else {
            LOGGER.info("The specified data type is actually unsupported: " + bufferType);
        }
        sampleModel = splitBands ? new BandedSampleModel(dataBufferType, dstWidth, dstHeight, dstWidth, banks, offsets) : new PixelInterleavedSampleModel(dataBufferType, dstWidth, dstHeight, nBands, dstWidth * nBands, offsets);
        GDALUtilities.closeDataSet(dataset);
        return Raster.createWritableRaster(sampleModel, imgBuffer, null);
    }

    protected File getDatasetSource(Object myInput) {
        if (this.datasetSource == null) {
            if (myInput instanceof File) {
                this.datasetSource = (File)myInput;
            } else if (myInput instanceof FileImageInputStreamExt) {
                this.datasetSource = ((FileImageInputStreamExt)myInput).getFile();
            } else if (this.input instanceof URL) {
                URL tempURL = (URL)this.input;
                if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                    try {
                        this.datasetSource = new File(URLDecoder.decode(tempURL.getFile(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Not a Valid Input ", e);
                    }
                }
            } else {
                throw new RuntimeException("Unable to retrieve the Data Source for the provided input");
            }
        }
        return this.datasetSource;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Setting Input");
        }
        if (this.imageInputStream != null) {
            this.reset();
            this.imageInputStream = null;
        }
        if (input == null) {
            throw new IllegalArgumentException("The provided input is null!");
        }
        if (input instanceof File) {
            this.datasetSource = (File)input;
            try {
                this.imageInputStream = ImageIO.createImageInputStream(input);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create a valid input stream ", e);
            }
        } else if (input instanceof FileImageInputStreamExt) {
            this.datasetSource = ((FileImageInputStreamExt)input).getFile();
            this.imageInputStream = (ImageInputStream)input;
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                try {
                    this.datasetSource = new File(URLDecoder.decode(tempURL.getFile(), "UTF-8"));
                    this.imageInputStream = ImageIO.createImageInputStream(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create a valid input stream ", e);
                }
            }
        } else if (input instanceof URIImageInputStream) {
            this.imageInputStream = (URIImageInputStream)input;
            this.datasetSource = null;
            this.uriSource = ((URIImageInputStream)input).getUri();
        }
        boolean isInputDecodable = false;
        if (this.imageInputStream != null) {
            Dataset dataSet = null;
            if (this.datasetSource != null) {
                dataSet = GDALUtilities.acquireDataSet(this.datasetSource.getAbsolutePath(), gdalconstConstants.GA_ReadOnly);
            } else if (this.uriSource != null) {
                String urisource = this.uriSource.toString();
                dataSet = GDALUtilities.acquireDataSet(urisource, gdalconstConstants.GA_ReadOnly);
            }
            if (dataSet != null) {
                isInputDecodable = ((GDALImageReaderSpi)this.getOriginatingProvider()).isDecodable(dataSet);
                GDALUtilities.closeDataSet(dataSet);
            } else {
                isInputDecodable = false;
            }
        }
        if (!isInputDecodable) {
            StringBuffer sb = new StringBuffer();
            if (this.imageInputStream == null) {
                sb.append("Unable to create a valid ImageInputStream for the provided input:").append(GDALUtilities.NEWLINE).append(input.toString());
            } else {
                sb.append("The Provided input is not supported by this reader");
            }
            throw new RuntimeException(sb.toString());
        }
        super.setInput(this.imageInputStream, seekForwardOnly, ignoreMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        super.dispose();
        Map map = this.datasetMap;
        synchronized (map) {
            if (this.imageInputStream != null) {
                try {
                    this.imageInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.imageInputStream = null;
            this.datasetMap.clear();
            this.datasetNames = null;
        }
    }

    public synchronized void reset() {
        super.setInput(null, false, false);
        this.dispose();
        this.isInitialized = false;
        this.nSubdatasets = -1;
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>(4);
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        this.imageType = new ImageTypeSpecifier(item.getColorModel(), item.getSampleModel());
        l.add(this.imageType);
        return l.iterator();
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int nDestBands;
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        int width = item.getWidth();
        int height = item.getHeight();
        SampleModel itemSampleModel = item.getSampleModel();
        int itemNBands = itemSampleModel.getNumBands();
        BufferedImage bi = null;
        ImageReadParam imageReadParam = param == null ? this.getDefaultReadParam() : param;
        ImageTypeSpecifier imageType = imageReadParam.getDestinationType();
        SampleModel destSampleModel = null;
        if (imageType != null) {
            destSampleModel = imageType.getSampleModel();
            nDestBands = destSampleModel.getNumBands();
        } else {
            bi = imageReadParam.getDestination();
            nDestBands = bi != null ? bi.getSampleModel().getNumBands() : itemNBands;
        }
        GDALImageReader.checkReadParamBandSettings(imageReadParam, itemNBands, nDestBands);
        int[] srcBands = imageReadParam.getSourceBands();
        int[] destBands = imageReadParam.getDestinationBands();
        Rectangle srcRegion = new Rectangle(0, 0, 0, 0);
        Rectangle destRegion = new Rectangle(0, 0, 0, 0);
        GDALImageReader.computeRegions(imageReadParam, width, height, bi, srcRegion, destRegion);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Source Region = " + srcRegion.toString());
            LOGGER.fine("Destination Region = " + destRegion.toString());
        }
        if (bi == null) {
            if (imageType == null) {
                ColorModel cm = item.getColorModel();
                bi = new BufferedImage(cm, (WritableRaster)this.readDatasetRaster(item, srcRegion, destRegion, srcBands), false, null);
            } else {
                ColorModel cm = imageType.getColorModel();
                bi = new BufferedImage(cm, (WritableRaster)this.readDatasetRaster(item, srcRegion, destRegion, srcBands, destSampleModel), false, null);
            }
        } else {
            Raster readRaster = this.readDatasetRaster(item, srcRegion, destRegion, srcBands);
            WritableRaster raster = bi.getRaster().createWritableChild(0, 0, bi.getWidth(), bi.getHeight(), 0, 0, null);
            raster.setRect(destRegion.x, destRegion.y, readRaster);
        }
        return bi;
    }

    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        return this.read(imageIndex, param).getData();
    }

    public BufferedImage read(int imageIndex) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("read(imageIndex)");
        }
        return this.read(imageIndex, null);
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getting NumImages");
        }
        this.initialize();
        return this.nSubdatasets;
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getHeight();
    }

    public int getTileHeight(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getTileHeight();
    }

    public int getTileWidth(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getTileWidth();
    }

    public String getProjection(int imageIndex) {
        return this.getDatasetMetadata(imageIndex).getProjection();
    }

    public double[] getGeoTransform(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGeoTransformation();
    }

    public List getGCPs(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGcps();
    }

    public String getGCPProjection(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGcpProjection();
    }

    public int getGCPCount(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGcpNumber();
    }

    public double getNoDataValue(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getNoDataValue(band);
    }

    public double getOffset(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getOffset(band);
    }

    public double getScale(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getScale(band);
    }

    public double getMinimum(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getMinimum(band);
    }

    public double getMaximum(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getMaximum(band);
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        this.initialize();
        return new GDALCommonIIOStreamMetadata(this.datasetNames);
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex);
    }
}

