/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.palette;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import org.vfny.geoserver.wms.responses.palette.EfficientInverseColorMapComputation;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapRasterOp;

public final class InverseColorMapOp
implements BufferedImageOp {
    protected final InverseColorMapRasterOp rasterOp;
    protected final IndexColorModel icm;
    protected final int alphaThreshold;
    protected final boolean hasAlpha;
    protected final int transparencyIndex;

    public InverseColorMapOp(IndexColorModel destCM, int quantizationColors, int alphaThreshold) {
        this.rasterOp = new InverseColorMapRasterOp(destCM, quantizationColors, alphaThreshold);
        this.icm = destCM;
        this.alphaThreshold = alphaThreshold;
        this.hasAlpha = this.icm.hasAlpha();
        this.transparencyIndex = this.icm.getTransparentPixel();
    }

    public InverseColorMapOp(IndexColorModel destCM) {
        this(destCM, 5, 1);
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (!(destCM instanceof IndexColorModel) || ((IndexColorModel)destCM).getTransparency() == 3) {
            return null;
        }
        return new BufferedImage(src.getWidth(), src.getHeight(), 13, (IndexColorModel)destCM);
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (dest == null) {
            dest = new BufferedImage(src.getWidth(), src.getHeight(), 13, this.icm);
        } else {
            if (!(dest.getColorModel() instanceof IndexColorModel) || ((IndexColorModel)dest.getColorModel()).getTransparency() != this.transparencyIndex) {
                throw new IllegalArgumentException();
            }
            if (((IndexColorModel)dest.getColorModel()).getTransparentPixel() != this.transparencyIndex) {
                throw new IllegalArgumentException();
            }
        }
        WritableRaster wr = dest.getRaster();
        WritableRaster ir = src.getRaster();
        this.rasterOp.filter(ir, wr);
        return dest;
    }

    public BufferedImage filterRenderedImage(RenderedImage src) {
        if (src instanceof BufferedImage) {
            return this.filter((BufferedImage)src, null);
        }
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13, this.icm);
        WritableRaster destWr = dest.getRaster();
        if (src.getNumXTiles() == 1 && src.getNumYTiles() == 1) {
            int minTileX = src.getMinTileX();
            int minTileY = src.getMinTileY();
            Raster sourceR = src.getTile(minTileX, minTileY);
            this.rasterOp.filter(sourceR.createChild(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight(), 0, 0, null), destWr);
            return dest;
        }
        int numBands = src.getSampleModel().getNumBands();
        int[] rgba = new int[numBands];
        boolean sourceHasAlpha = numBands % 2 == 0;
        int alphaBand = sourceHasAlpha ? numBands - 1 : -1;
        EfficientInverseColorMapComputation invCM = this.rasterOp.getInvCM();
        int minx_ = src.getMinX();
        int miny_ = src.getMinY();
        int srcW_ = src.getWidth();
        int srcH_ = src.getHeight();
        int maxx_ = minx_ + srcW_;
        int maxy_ = miny_ + srcH_;
        int minTileX = src.getMinTileX();
        int minTileY = src.getMinTileY();
        int tileW = src.getTileWidth();
        int tileH = src.getTileHeight();
        int maxTileX = minTileX + src.getNumXTiles();
        int maxTileY = minTileY + src.getNumYTiles();
        int dstTempX = 0;
        int dstTempY = 0;
        for (int ty = minTileY; ty < maxTileY; ++ty) {
            dstTempX = 0;
            int actualWidth = 0;
            int actualHeight = 0;
            for (int tx = minTileX; tx < maxTileX; ++tx) {
                Raster r = src.getTile(tx, ty);
                int minx = r.getMinX();
                int miny = r.getMinY();
                minx = minx < minx_ ? minx_ : minx;
                miny = miny < miny_ ? miny_ : miny;
                int maxx = minx + tileW;
                int maxy = miny + tileH;
                maxx = maxx > maxx_ ? maxx_ : maxx;
                maxy = maxy > maxy_ ? maxy_ : maxy;
                actualWidth = maxx - minx;
                actualHeight = maxy - miny;
                int j = miny;
                int jj = dstTempY;
                while (j < maxy) {
                    int i = minx;
                    int ii = dstTempX;
                    while (i < maxx) {
                        r.getPixel(i, j, rgba);
                        if (!sourceHasAlpha || !this.hasAlpha || sourceHasAlpha && this.hasAlpha && rgba[alphaBand] >= this.alphaThreshold) {
                            int val = invCM.getIndexNearest(rgba[0] & 0xFF, rgba[1] & 0xFF, rgba[2]);
                            if (this.hasAlpha && val >= this.transparencyIndex) {
                                ++val;
                            }
                            destWr.setSample(ii, jj, 0, (byte)(val & 0xFF));
                        } else {
                            destWr.setSample(ii, jj, 0, this.transparencyIndex);
                        }
                        ++i;
                        ++ii;
                    }
                    ++j;
                    ++jj;
                }
                dstTempX += actualWidth;
            }
            dstTempY += actualHeight;
        }
        return dest;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(src.getWidth(), src.getHeight());
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public IndexColorModel getIcm() {
        return this.icm;
    }
}

