/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.kml.RegionatingStrategy;
import org.vfny.geoserver.wms.responses.map.kml.RegionatingStrategyFactory;

public class ReflectiveRegionatingStrategyFactory
implements RegionatingStrategyFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.geosearch");
    String myName;
    String myClassName;
    Class myStrategyClass;

    public ReflectiveRegionatingStrategyFactory(String name, String className) {
        this.myName = name;
        this.myClassName = className;
    }

    public ReflectiveRegionatingStrategyFactory(String name, Class strategy) {
        this.myName = name;
        this.myStrategyClass = strategy;
    }

    public boolean canHandle(String strategyName) {
        return this.myName != null && this.myName.equalsIgnoreCase(strategyName);
    }

    public String getName() {
        return this.myName;
    }

    public RegionatingStrategy createStrategy() {
        try {
            return (RegionatingStrategy)this.getStrategyClass().newInstance();
        }
        catch (Exception e) {
            throw new WmsException(e);
        }
    }

    protected Class getStrategyClass() {
        if (this.myStrategyClass != null) {
            return this.myStrategyClass;
        }
        try {
            this.myStrategyClass = Class.forName(this.myClassName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to find class " + this.myClassName + " for ReflectiveRegionatingStrategy.", e);
        }
        return this.myStrategyClass;
    }
}

