/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.geoserver.platform.ServiceException;
import org.geotools.map.MapLayer;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformer;
import org.vfny.geoserver.wms.responses.map.png.PNGMapProducer;

public class KMZMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.kmz");
    static final String MIME_TYPE = "application/vnd.google-earth.kmz+xml";
    public static final String[] OUTPUT_FORMATS = new String[]{"application/vnd.google-earth.kmz+xml", "application/vnd.google-earth.kmz", "kmz", "application/vnd.google-earth.kmz xml"};
    PNGMapProducer mapProducer;
    KMLTransformer transformer;

    public KMZMapProducer(WMS wms) {
        super(MIME_TYPE, OUTPUT_FORMATS);
        this.mapProducer = new PNGMapProducer(wms);
    }

    public void abort() {
        LOGGER.fine("aborting KMZ map response");
        this.mapContext = null;
        this.mapProducer = null;
        this.transformer = null;
    }

    public String getContentDisposition() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mapContext.getLayerCount(); ++i) {
            MapLayer layer = this.mapContext.getLayer(i);
            String title = layer.getFeatureSource().getSchema().getName().getLocalPart();
            if (title == null || title.equals("")) continue;
            sb.append(title).append("_");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return "attachment; filename=" + sb.toString() + ".kml";
        }
        return "attachment; filename=geoserver.kml";
    }

    public String getContentType() throws IllegalStateException {
        return MIME_TYPE;
    }

    public void produceMap() throws WmsException {
        this.transformer = new KMLTransformer();
        this.transformer.setKmz(true);
        GetMapRequest request = this.mapContext.getRequest();
        WMS wms = request.getWMS();
        Charset encoding = wms.getCharSet();
        this.transformer.setEncoding(encoding);
        this.transformer.setIndentation(3);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        ZipOutputStream zip = new ZipOutputStream(out);
        ZipEntry entry = new ZipEntry("wms.kml");
        zip.putNextEntry(entry);
        try {
            this.transformer.transform((Object)this.mapContext, zip);
            zip.closeEntry();
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
        for (int i = 0; i < this.mapContext.getLayerCount(); ++i) {
            MapLayer mapLayer = this.mapContext.getLayer(i);
            WMSMapContext mapContext = new WMSMapContext();
            mapContext.addLayer(mapLayer);
            mapContext.setRequest(this.mapContext.getRequest());
            mapContext.setMapHeight(this.mapContext.getMapHeight());
            mapContext.setMapWidth(this.mapContext.getMapWidth());
            mapContext.setAreaOfInterest(this.mapContext.getAreaOfInterest());
            mapContext.setBgColor(this.mapContext.getBgColor());
            mapContext.setBuffer(this.mapContext.getBuffer());
            mapContext.setContactInformation(this.mapContext.getContactInformation());
            mapContext.setKeywords(this.mapContext.getKeywords());
            mapContext.setAbstract(this.mapContext.getAbstract());
            mapContext.setTransparent(true);
            this.mapProducer.setMapContext(mapContext);
            this.mapProducer.produceMap();
            entry = new ZipEntry("layer_" + i + ".png");
            zip.putNextEntry(entry);
            this.mapProducer.writeTo(zip);
            zip.closeEntry();
        }
        zip.finish();
        zip.flush();
    }
}

