/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import java.util.logging.Level;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.kml.ExternalSortRegionatingStrategy;

public class GeometryRegionatingStrategy
extends ExternalSortRegionatingStrategy {
    protected void checkAttribute(WMSMapContext con, SimpleFeatureType ft) {
        Map options = con.getRequest().getFormatOptions();
        this.attribute = (String)options.get("regionateAttr");
        if (this.attribute == null) {
            this.attribute = this.typeInfo.getRegionateAttribute();
        }
        if (this.attribute == null || ft.getDescriptor(this.attribute) == null) {
            LOGGER.log(Level.FINER, "No attribute specified, falling back on geometry attribute");
            this.attribute = ft.getGeometryDescriptor().getLocalName();
        } else {
            AttributeType attributeType = ft.getType(this.attribute);
            if (attributeType == null) {
                throw new WmsException("Could not find regionating attribute " + this.attribute + " in layer " + this.typeInfo.getName());
            }
        }
        this.h2Type = "DOUBLE";
    }

    protected String checkAttribute(FeatureTypeInfo cfg) {
        String attribute = cfg.getRegionateAttribute();
        try {
            if (attribute != null && cfg.getFeatureType().getDescriptor(attribute) != null) {
                return attribute;
            }
            return cfg.getFeatureType().getGeometryDescriptor().getLocalName();
        }
        catch (Exception e) {
            LOGGER.severe("Couldn't get attribute name due to " + e);
            return null;
        }
    }

    protected Double getSortAttributeValue(SimpleFeature f) {
        Geometry g = (Geometry)f.getAttribute(this.attribute);
        if (g instanceof MultiPoint) {
            return ((MultiPoint)g).getNumGeometries();
        }
        if (g instanceof Polygon || g instanceof MultiPolygon) {
            return g.getArea();
        }
        return g.getLength();
    }
}

