/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DescribeLayerTransformer
extends TransformerBase {
    private String baseUrl;
    private GeoServer geoserver;
    private String version;

    public DescribeLayerTransformer(String baseUrl, GeoServer gs, String version) {
        if (baseUrl == null) {
            throw new NullPointerException();
        }
        this.baseUrl = baseUrl;
        this.geoserver = gs;
        this.version = version;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new DescribeLayerTranslator(handler);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        String dtdUrl = RequestUtils.proxifiedBaseURL((String)this.baseUrl, (String)this.geoserver.getProxyBaseUrl());
        dtdUrl = dtdUrl + "schemas/wms/1.1.1/WMS_DescribeLayerResponse.dtd";
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    private class DescribeLayerTranslator
    extends TransformerBase.TranslatorSupport {
        public DescribeLayerTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof DescribeLayerRequest)) {
                throw new IllegalArgumentException();
            }
            DescribeLayerRequest req = (DescribeLayerRequest)((Object)o);
            AttributesImpl versionAtt = new AttributesImpl();
            versionAtt.addAttribute("", "version", "version", "", DescribeLayerTransformer.this.version);
            this.start("WMS_DescribeLayerResponse", versionAtt);
            this.handleLayers(req);
            this.end("WMS_DescribeLayerResponse");
        }

        private void handleLayers(DescribeLayerRequest req) {
            String url = RequestUtils.proxifiedBaseURL((String)req.getBaseUrl(), (String)req.getServiceConfig().getGeoServer().getProxyBaseUrl()) + "wfs/WfsDispatcher?";
            AttributesImpl layerAtts = new AttributesImpl();
            layerAtts.addAttribute("", "name", "name", "", "");
            layerAtts.addAttribute("", "wfs", "wfs", "", url);
            AttributesImpl queryAtts = new AttributesImpl();
            queryAtts.addAttribute("", "typeName", "typeName", "", "");
            for (MapLayerInfo layer : req.getLayers()) {
                layerAtts.setAttribute(0, "", "name", "name", "", layer.getName());
                this.start("LayerDescription", layerAtts);
                queryAtts.setAttribute(0, "", "typeName", "typeName", "", layer.getName());
                this.element("Query", null, queryAtts);
                this.end("LayerDescription");
            }
        }
    }
}

