/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.platform.ServiceException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.vfny.geoserver.wms.responses.featureInfo.AbstractFeatureInfoResponse;

public class TextFeatureInfoResponse
extends AbstractFeatureInfoResponse {
    public TextFeatureInfoResponse() {
        this.format = "text/plain";
        this.supportedFormats = Collections.singletonList("text/plain");
    }

    public HashMap getResponseHeaders() {
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.getRequest().getGeoServer().getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        PrintWriter writer = new PrintWriter(osw);
        int featuresPrinted = 0;
        int maxfeatures = this.getRequest().getFeatureCount();
        FeatureIterator reader = null;
        try {
            int size = this.results.size();
            for (int i = 0; i < size; ++i) {
                FeatureCollection fr = (FeatureCollection)this.results.get(i);
                reader = fr.features();
                if (reader.hasNext() && featuresPrinted < maxfeatures) {
                    writer.println("Results for FeatureType '" + ((SimpleFeatureType)fr.getSchema()).getTypeName() + "':");
                }
                while (reader.hasNext()) {
                    SimpleFeature f = (SimpleFeature)reader.next();
                    SimpleFeatureType schema = f.getFeatureType();
                    List types = schema.getAttributeDescriptors();
                    if (featuresPrinted >= maxfeatures) continue;
                    writer.println("--------------------------------------------");
                    for (AttributeDescriptor descriptor : types) {
                        Name name = descriptor.getName();
                        if (Geometry.class.isAssignableFrom(descriptor.getType().getBinding())) {
                            Geometry g = (Geometry)f.getAttribute(name);
                            writer.println(name + " = [GEOMETRY (" + g.getGeometryType() + ") with " + g.getNumPoints() + " points]");
                            continue;
                        }
                        writer.println(name + " = " + f.getAttribute(name));
                    }
                    writer.println("--------------------------------------------");
                    ++featuresPrinted;
                }
            }
        }
        catch (Exception ife) {
            LOGGER.log(Level.WARNING, "Error generating getFeaturInfo, HTML format", ife);
            writer.println("Unable to generate information " + ife);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (featuresPrinted == 0) {
            writer.println("no features were found");
        }
        writer.flush();
    }

    public String getContentDisposition() {
        return null;
    }
}

