/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.wms.responses.featureInfo.AbstractFeatureInfoResponse;

public class HTMLTableFeatureInfoResponse
extends AbstractFeatureInfoResponse {
    private static Configuration templateConfig = new Configuration();
    GeoServerTemplateLoader templateLoader;

    public HTMLTableFeatureInfoResponse() {
        this.format = "text/html";
        this.supportedFormats = Collections.singletonList(this.format);
    }

    public HashMap getResponseHeaders() {
        return new HashMap();
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.getRequest().getGeoServer().getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        Template header = null;
        Template footer = null;
        if (this.results.size() == 1) {
            SimpleFeatureType templateFeatureType = (SimpleFeatureType)((FeatureCollection)this.results.get(0)).getSchema();
            header = this.getTemplate(templateFeatureType, "header.ftl", charSet);
            footer = this.getTemplate(templateFeatureType, "footer.ftl", charSet);
        } else {
            header = this.getTemplate(null, "header.ftl", charSet);
            footer = this.getTemplate(null, "footer.ftl", charSet);
        }
        try {
            header.process(null, (Writer)osw);
        }
        catch (TemplateException e) {
            String msg = "Error occured processing header template.";
            throw (IOException)new IOException(msg).initCause(e);
        }
        for (FeatureCollection fc : this.results) {
            if (fc.size() <= 0) continue;
            SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
            Template content = this.getTemplate(ft, "content.ftl", charSet);
            try {
                content.process((Object)fc, (Writer)osw);
            }
            catch (TemplateException e) {
                String msg = "Error occured processing content template " + content.getName() + " for " + ft.getTypeName();
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
        if (footer != null) {
            try {
                footer.process(null, (Writer)osw);
            }
            catch (TemplateException e) {
                String msg = "Error occured processing footer template.";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
        osw.flush();
    }

    public String getContentDisposition() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Template getTemplate(SimpleFeatureType featureType, String templateFileName, Charset charset) throws IOException {
        if (this.templateLoader == null) {
            this.templateLoader = new GeoServerTemplateLoader(this.getClass());
        }
        if (featureType != null) {
            String namespaceURI;
            String localName;
            Data catalog = (Data)GeoServerExtensions.bean((String)"data");
            FeatureTypeInfo featureTypeInfo = catalog.getFeatureTypeInfo(localName = featureType.getName().getLocalPart(), namespaceURI = featureType.getName().getNamespaceURI());
            if (featureTypeInfo == null) {
                CoverageInfo cInfo = catalog.getCoverageInfo(localName);
                if (cInfo == null) throw new IllegalArgumentException("Can't find neither a FeatureType nor a CoverageInfo named " + localName);
                this.templateLoader.setCoverageName(localName);
            } else {
                this.templateLoader.setFeatureType(featureType);
            }
        }
        Configuration configuration = templateConfig;
        synchronized (configuration) {
            templateConfig.setTemplateLoader((TemplateLoader)this.templateLoader);
            Template t = templateConfig.getTemplate(templateFileName);
            t.setEncoding(charset.name());
            return t;
        }
    }

    static {
        templateConfig.setObjectWrapper((ObjectWrapper)new FeatureWrapper());
    }
}

