/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import java.util.List;
import org.geoserver.platform.ServiceException;
import org.geotools.styling.Style;
import org.opengis.filter.Filter;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;

public abstract class GetFeatureInfoDelegate
implements Response {
    private GetFeatureInfoRequest request;

    public void execute(Request request) throws ServiceException {
        this.execute((GetFeatureInfoRequest)request);
    }

    protected void execute(GetFeatureInfoRequest request) throws WmsException {
        this.request = request;
        MapLayerInfo[] layers = request.getQueryLayers();
        List filterList = request.getGetMapRequest().getFilter();
        Filter[] filters = filterList != null ? filterList.toArray(new Filter[filterList.size()]) : new Filter[layers.length];
        List getMapStyles = request.getGetMapRequest().getStyles();
        Style[] styles = new Style[layers.length];
        block0: for (int i = 0; i < styles.length; ++i) {
            MapLayerInfo[] getMapLayers = request.getGetMapRequest().getLayers();
            String targetLayer = layers[i].getName();
            for (int j = 0; j < getMapLayers.length; ++j) {
                if (!getMapLayers[j].getName().equals(targetLayer)) continue;
                if (getMapStyles != null && getMapStyles.size() > 0) {
                    styles[i] = (Style)getMapStyles.get(j);
                }
                if (styles[i] != null) continue block0;
                styles[i] = getMapLayers[j].getDefaultStyle();
                continue block0;
            }
        }
        int x = request.getXPixel();
        int y = request.getYPixel();
        int buffer = request.getGetMapRequest().getBuffer();
        this.execute(layers, styles, filters, x, y, buffer);
    }

    public void abort(Service gs) {
    }

    protected abstract void execute(MapLayerInfo[] var1, Style[] var2, Filter[] var3, int var4, int var5, int var6) throws WmsException;

    protected GetFeatureInfoRequest getRequest() {
        return this.request;
    }

    public boolean canProduce(String mapFormat) {
        return this.getSupportedFormats().contains(mapFormat);
    }

    public abstract List getSupportedFormats();
}

