/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.GetLegendGraphicProducerSpi;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;

public class GetLegendGraphicResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)GetLegendGraphicResponse.class.getPackage().getName());
    private GetLegendGraphicProducer delegate;
    private ApplicationContext applicationContext;

    public GetLegendGraphicResponse(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request req) throws ServiceException {
        GetLegendGraphicRequest request = (GetLegendGraphicRequest)req;
        String outputFormat = request.getFormat();
        this.delegate = this.getDelegate(outputFormat);
        this.delegate.produceLegendGraphic(request);
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.delegate == null) {
            throw new IllegalStateException("No request has been processed");
        }
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("returning content encoding null");
        }
        return null;
    }

    public void abort(Service gs) {
        if (this.delegate != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("asking delegate for aborting the process");
            }
            this.delegate.abort();
        }
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        block4: {
            try {
                if (this.delegate == null) {
                    throw new IllegalStateException("No GetMapDelegate is setted, make sure you have called execute and it has succeed");
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(new StringBuffer("asking delegate for write to ").append(out).toString());
                }
                this.delegate.writeTo(out);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINER)) break block4;
                LOGGER.finer(new StringBuffer("asking delegate for write to ").append(out).toString());
            }
        }
    }

    private GetLegendGraphicProducer getDelegate(String outputFormat) throws WmsException {
        List producers = GeoServerExtensions.extensions(GetLegendGraphicProducerSpi.class);
        for (GetLegendGraphicProducerSpi factory : producers) {
            if (!factory.canProduce(outputFormat)) continue;
            return factory.createLegendProducer(outputFormat);
        }
        throw new WmsException("There is no support for creating legends in " + outputFormat + " format", "InvalidFormat");
    }

    public static boolean supportsFormat(String mimeType, ApplicationContext context) {
        return GetLegendGraphicResponse.supportsFormat(mimeType);
    }

    public static boolean supportsFormat(String mimeType) {
        return GetLegendGraphicResponse.loadLegendFormats().contains(mimeType);
    }

    public static Set getFormats(ApplicationContext context) {
        return GetLegendGraphicResponse.getFormats();
    }

    public static Set getFormats() {
        return GetLegendGraphicResponse.loadLegendFormats();
    }

    private static Set loadLegendFormats() {
        List producers = GeoServerExtensions.extensions(GetLegendGraphicProducerSpi.class);
        HashSet formats = new HashSet();
        for (GetLegendGraphicProducerSpi producer : producers) {
            formats.addAll(producer.getSupportedFormats());
        }
        return formats;
    }

    public String getContentDisposition() {
        return null;
    }
}

