/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;

public class DescribeLayerKvpRequestReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger((String)DescribeLayerKvpRequestReader.class.getPackage().getName());

    public DescribeLayerKvpRequestReader(Map params, WMS wms) {
        super(params, wms);
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        int layerCount;
        if (request == null) {
            throw new NullPointerException("request");
        }
        DescribeLayerRequest req = new DescribeLayerRequest((WMS)this.serviceConfig);
        req.setHttpServletRequest(request);
        String version = this.getValue("VERSION");
        if (null == version) {
            throw new WmsException("Version parameter not provided for DescribeLayer operation", "NoVersionInfo", ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.getWMS();
        if (!WMS.getVersion().equals(version)) {
            StringBuilder stringBuilder = new StringBuilder().append("Wrong value for version parameter: ").append(version).append(". This server accetps version ");
            this.getWMS();
            throw new WmsException(stringBuilder.append(WMS.getVersion()).toString(), "InvalidVersion", ((Object)((Object)this)).getClass().getSimpleName());
        }
        req.setVersion(version);
        String layersParam = this.getValue("LAYERS");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(layersParam);
        }
        List layers = DescribeLayerKvpRequestReader.readFlat((String)layersParam, (String)",");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(layers.toString());
        }
        if ((layerCount = layers.size()) == 0) {
            throw new WmsException("No LAYERS has been requested", "NoLayerRequested", ((Object)((Object)this)).getClass().getName());
        }
        Data catalog = req.getWMS().getData();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(catalog.toString());
        }
        String layerName = null;
        MapLayerInfo layer = null;
        for (int i = 0; i < layerCount; ++i) {
            layerName = (String)layers.get(i);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Looking for layer ").append(layerName).toString());
            }
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("looking featuretypeinfos");
                }
                FeatureTypeInfo ftype = catalog.getFeatureTypeInfo(layerName);
                layer = new MapLayerInfo();
                layer.setFeature(ftype);
                req.addLayer(layer);
                continue;
            }
            catch (NoSuchElementException fex) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("looking coverageinfos");
                    }
                    CoverageInfo cinfo = catalog.getCoverageInfo(layerName);
                    layer = new MapLayerInfo();
                    layer.setCoverage(cinfo);
                    req.addLayer(layer);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(new StringBuffer(layerName).append(" found").toString());
                    }
                }
                catch (NoSuchElementException cex) {
                    throw new WmsException(cex, layerName + ": no such layer on this server", ((Object)((Object)this)).getClass().getSimpleName(), "LayerNotDefined");
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(new StringBuffer(layerName).append(" found").toString());
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("parsed request ").append((Object)req).toString());
        }
        return req;
    }
}

