/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PointLineAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class PointCoveredByEndPointOfLineValidation
extends PointLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        FeatureSource lineSource = (FeatureSource)layers.get(this.getRestrictedLineTypeRef());
        FeatureSource pointSource = (FeatureSource)layers.get(this.getPointTypeRef());
        Object[] points = pointSource.getFeatures().toArray();
        Object[] lines = lineSource.getFeatures().toArray();
        if (!envelope.contains(pointSource.getBounds())) {
            results.error((SimpleFeature)points[0], "Point Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains(lineSource.getBounds())) {
            results.error((SimpleFeature)lines[0], "Line Feature Source is not contained within the Envelope provided.");
            return false;
        }
        for (int i = 0; i < lines.length; ++i) {
            SimpleFeature tmp = (SimpleFeature)lines[i];
            Geometry gt = (Geometry)tmp.getDefaultGeometry();
            if (!(gt instanceof LineString)) continue;
            LineString ls = (LineString)gt;
            Point str = ls.getStartPoint();
            Point end = ls.getEndPoint();
            for (int j = 0; j < points.length; ++j) {
                Point pt;
                SimpleFeature tmp2 = (SimpleFeature)points[j];
                Geometry gt2 = (Geometry)tmp2.getDefaultGeometry();
                if (!(gt2 instanceof Point) || !(pt = (Point)gt2).equalsExact(str) && !pt.equalsExact(end)) continue;
                return true;
            }
        }
        return false;
    }
}

